/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.commands;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.commands.Messages;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.widgets.Display;

public class CreateDiagramObjectCommand
extends Command {
    protected CreateRequest fRequest;
    protected EditPart fParentEditPart;
    protected IDiagramModelContainer fParent;
    protected IDiagramModelObject fChild;
    protected Rectangle fBounds;

    public CreateDiagramObjectCommand(EditPart parentEditPart, CreateRequest request, Rectangle bounds) {
        this.fParentEditPart = parentEditPart;
        this.fParent = (IDiagramModelContainer)this.fParentEditPart.getModel();
        this.fRequest = request;
        this.fBounds = bounds;
        this.setLabel(Messages.CreateDiagramObjectCommand_0);
    }

    public void execute() {
        this.addChild();
        this.editNameOfNewObject();
    }

    protected void addChild() {
        this.fChild = (IDiagramModelObject)this.fRequest.getNewObject();
        this.fChild.getBounds().setLocation(this.fBounds.x, this.fBounds.y);
        Dimension preferredSize = this.getPreferredSize();
        if (preferredSize != null) {
            this.fChild.getBounds().setSize(preferredSize.width, preferredSize.height);
        } else if (this.fBounds.width != -1 && this.fBounds.height != -1) {
            this.fChild.getBounds().setSize(this.fBounds.width, this.fBounds.height);
        }
        this.redo();
    }

    protected Dimension getPreferredSize() {
        return null;
    }

    public void undo() {
        this.fParent.getChildren().remove((Object)this.fChild);
    }

    public void redo() {
        this.fParent.getChildren().add((Object)this.fChild);
    }

    protected void editNameOfNewObject() {
        EditPart editPart;
        EditPartViewer viewer;
        if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("editNameOnNewObject") && (viewer = this.fParentEditPart.getViewer()) != null && (editPart = (EditPart)viewer.getEditPartRegistry().get(this.fChild)) != null) {
            Display.getCurrent().asyncExec(() -> {
                Request directEditRequest = new Request((Object)"direct edit");
                editPart.performRequest(directEditRequest);
            });
        }
    }

    public void dispose() {
        this.fRequest = null;
        this.fParent = null;
        this.fChild = null;
        this.fBounds = null;
    }
}

