/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.commands;

import com.archimatetool.editor.diagram.commands.DeleteDiagramConnectionCommand;
import com.archimatetool.editor.diagram.commands.DeleteDiagramObjectCommand;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public final class DiagramCommandFactory {
    public static Command createDeleteDiagramObjectCommand(IDiagramModelObject object) {
        return DiagramCommandFactory.createDeleteDiagramObjectCommand(object, true);
    }

    public static Command createDeleteDiagramObjectCommand(IDiagramModelObject object, boolean deleteChildren) {
        CompoundCommand result = new CompoundCommand();
        DiagramCommandFactory.addDeleteDiagramObjectCommands(object, result, deleteChildren);
        return result.unwrap();
    }

    private static void addDeleteDiagramObjectCommands(IDiagramModelObject object, CompoundCommand result, boolean deleteChildren) {
        result.add((Command)new DeleteDiagramObjectCommand(object));
        for (IDiagramModelConnection connection : object.getSourceConnections()) {
            result.add(DiagramCommandFactory.createDeleteDiagramConnectionCommand(connection));
        }
        for (IDiagramModelConnection connection : object.getTargetConnections()) {
            result.add(DiagramCommandFactory.createDeleteDiagramConnectionCommand(connection));
        }
        if (deleteChildren && object instanceof IDiagramModelContainer) {
            IDiagramModelContainer container = (IDiagramModelContainer)object;
            for (IDiagramModelObject child : container.getChildren()) {
                DiagramCommandFactory.addDeleteDiagramObjectCommands(child, result, deleteChildren);
            }
        }
    }

    public static Command createDeleteDiagramConnectionCommand(IDiagramModelConnection connection) {
        CompoundCommand result = new CompoundCommand();
        DiagramCommandFactory.addDeleteDiagramConnectionCommands(connection, result);
        return result.unwrap();
    }

    private static void addDeleteDiagramConnectionCommands(IDiagramModelConnection connection, CompoundCommand result) {
        for (IDiagramModelConnection conn : connection.getSourceConnections()) {
            result.add(DiagramCommandFactory.createDeleteDiagramConnectionCommand(conn));
        }
        for (IDiagramModelConnection conn : connection.getTargetConnections()) {
            result.add(DiagramCommandFactory.createDeleteDiagramConnectionCommand(conn));
        }
        result.add((Command)new DeleteDiagramConnectionCommand(connection));
    }
}

