/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.commands;

import com.archimatetool.editor.diagram.commands.CreateDiagramConnectionCommand;
import com.archimatetool.editor.diagram.commands.Messages;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModelConnection;
import org.eclipse.gef.commands.Command;

public class ReconnectDiagramConnectionCommand
extends Command {
    protected IDiagramModelConnection fConnection;
    protected IConnectable fNewSource;
    protected IConnectable fNewTarget;
    protected IConnectable fOldSource;
    protected IConnectable fOldTarget;
    protected Command fBendpointCommand;

    public ReconnectDiagramConnectionCommand(IDiagramModelConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        this.fConnection = connection;
        this.fOldSource = connection.getSource();
        this.fOldTarget = connection.getTarget();
    }

    public void setNewSource(IConnectable source) {
        this.fNewSource = source;
        this.fNewTarget = null;
        this.setLabel(Messages.ReconnectDiagramConnectionCommand_0);
    }

    public void setNewTarget(IConnectable target) {
        this.fNewTarget = target;
        this.fNewSource = null;
        this.setLabel(Messages.ReconnectDiagramConnectionCommand_1);
    }

    public boolean canExecute() {
        if (this.fNewSource != null) {
            return this.checkSourceConnection();
        }
        if (this.fNewTarget != null) {
            return this.checkTargetConnection();
        }
        return false;
    }

    protected boolean checkSourceConnection() {
        return this.fOldSource != this.fNewSource;
    }

    protected boolean checkTargetConnection() {
        return this.fOldTarget != this.fNewTarget;
    }

    public void execute() {
        this.doConnection();
        if (this.fConnection.getSource() == this.fConnection.getTarget() && this.fConnection.getBendpoints().size() < 1) {
            this.fBendpointCommand = CreateDiagramConnectionCommand.createBendPointsForCircularConnectionCommand(this.fConnection);
            if (this.fBendpointCommand != null) {
                this.fBendpointCommand.execute();
            }
        }
    }

    public void redo() {
        this.doConnection();
        if (this.fBendpointCommand != null) {
            this.fBendpointCommand.redo();
        }
    }

    public void undo() {
        if (this.fBendpointCommand != null) {
            this.fBendpointCommand.undo();
        }
        this.fConnection.connect(this.fOldSource, this.fOldTarget);
    }

    protected void doConnection() {
        if (this.fNewSource != null) {
            this.fConnection.connect(this.fNewSource, this.fOldTarget);
        } else if (this.fNewTarget != null) {
            this.fConnection.connect(this.fOldSource, this.fNewTarget);
        } else {
            throw new IllegalStateException("Should not happen");
        }
    }

    public void dispose() {
        this.fConnection = null;
        this.fNewSource = null;
        this.fNewTarget = null;
        this.fOldSource = null;
        this.fOldTarget = null;
    }
}

