/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.dialog;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.dialog.Messages;
import com.archimatetool.editor.diagram.dialog.NestedConnectionInfo;
import com.archimatetool.editor.preferences.ConnectionPreferences;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class NewNestedRelationDialog
extends ExtendedTitleAreaDialog {
    private static String HELP_ID = "com.archimatetool.help.NewNestedRelationDialog";
    private RelationsTableViewer fTableViewer;
    private IDiagramModelArchimateObject fSourceObject;
    private IDiagramModelArchimateObject fTargetObject;
    private NestedConnectionInfo fSelected;

    public NewNestedRelationDialog(IDiagramModelArchimateObject sourceObject, IDiagramModelArchimateObject targetObject) {
        super(Display.getCurrent().getActiveShell(), "NewNestedRelationDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/new_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSourceObject = sourceObject;
        this.fTargetObject = targetObject;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.NewNestedRelationDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.setTitle(Messages.NewNestedRelationDialog_1);
        String message = NLS.bind((String)Messages.NewNestedRelationDialog_2, (Object)this.fSourceObject.getName(), (Object)this.fTargetObject.getName());
        this.setMessage(message);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite client = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        Composite tableComp = new Composite(client, 2048);
        tableComp.setLayout((Layout)new TableColumnLayout());
        tableComp.setLayoutData((Object)new GridData(1808));
        this.fTableViewer = new RelationsTableViewer(tableComp, 0);
        this.fTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.setInput("");
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NewNestedRelationDialog.this.okPressed();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewNestedRelationDialog.this.fSelected = (NestedConnectionInfo)((IStructuredSelection)NewNestedRelationDialog.this.fTableViewer.getSelection()).getFirstElement();
            }
        });
        if (this.fTableViewer.validRelations != null && !this.fTableViewer.validRelations.isEmpty()) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fTableViewer.validRelations.get(0)));
        }
        return composite;
    }

    @Override
    protected Point getDefaultDialogSize() {
        return new Point(500, 350);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(1).setText(Messages.NewNestedRelationDialog_3);
    }

    public NestedConnectionInfo getSelected() {
        return this.fSelected;
    }

    private class RelationsTableViewer
    extends TableViewer {
        List<NestedConnectionInfo> validRelations;

        RelationsTableViewer(Composite parent, int style) {
            super(parent, 0x10000 | style);
            this.setColumns();
            this.setContentProvider((IContentProvider)new RelationsTableViewerContentProvider());
            this.setLabelProvider((IBaseLabelProvider)new RelationsTableViewerLabelCellProvider());
        }

        private void setColumns() {
            Table table = this.getTable();
            table.setHeaderVisible(false);
            TableColumnLayout layout = (TableColumnLayout)this.getControl().getParent().getLayout();
            TableViewerColumn column = new TableViewerColumn((TableViewer)this, 0);
            layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, false));
        }

        private class RelationsTableViewerContentProvider
        implements IStructuredContentProvider {
            private RelationsTableViewerContentProvider() {
            }

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                RelationsTableViewer.this.validRelations = this.createValidRelationships();
                return RelationsTableViewer.this.validRelations.toArray();
            }

            private List<NestedConnectionInfo> createValidRelationships() {
                ArrayList<NestedConnectionInfo> list = new ArrayList<NestedConnectionInfo>();
                for (EClass eClass : ConnectionPreferences.getRelationsClassesForNewRelations()) {
                    if (!this.isAllowedRelationInViewpoint((IDiagramModelArchimateComponent)((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fSourceObject, eClass) || !ArchimateModelUtils.isValidRelationship((IArchimateConcept)((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fSourceObject.getArchimateElement(), (IArchimateConcept)((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fTargetObject.getArchimateElement(), (EClass)eClass)) continue;
                    list.add(new NestedConnectionInfo(((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fSourceObject, ((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fTargetObject, false, eClass));
                }
                for (EClass eClass : ConnectionPreferences.getRelationsClassesForNewReverseRelations()) {
                    if (!this.isAllowedRelationInViewpoint((IDiagramModelArchimateComponent)((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fTargetObject, eClass) || !ArchimateModelUtils.isValidRelationship((IArchimateConcept)((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fTargetObject.getArchimateElement(), (IArchimateConcept)((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fSourceObject.getArchimateElement(), (EClass)eClass)) continue;
                    list.add(new NestedConnectionInfo(((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fTargetObject, ((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationDialog.this.fSourceObject, true, eClass));
                }
                return list;
            }

            private boolean isAllowedRelationInViewpoint(IDiagramModelArchimateComponent dmc, EClass type) {
                if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewpointsHidePaletteElements")) {
                    return true;
                }
                return ViewpointManager.INSTANCE.isAllowedConceptForDiagramModel((IArchimateDiagramModel)dmc.getDiagramModel(), type);
            }
        }

        private class RelationsTableViewerLabelCellProvider
        extends LabelProvider {
            private RelationsTableViewerLabelCellProvider() {
            }

            public String getText(Object element) {
                NestedConnectionInfo info = (NestedConnectionInfo)element;
                String relationshipName = ArchiLabelProvider.INSTANCE.getDefaultName(info.getRelationshipType());
                String reverse = info.isReverse() ? Messages.NewNestedRelationDialog_4 : "";
                String sentence = ArchiLabelProvider.INSTANCE.getRelationshipSentence(info.getRelationshipType(), (IArchimateConcept)info.getSourceObject().getArchimateConcept(), (IArchimateConcept)info.getTargetObject().getArchimateConcept());
                return NLS.bind((String)Messages.NewNestedRelationDialog_5, (Object[])new Object[]{relationshipName, reverse, sentence});
            }

            public Image getImage(Object element) {
                return ArchiLabelProvider.INSTANCE.getImage(((NestedConnectionInfo)element).getRelationshipType());
            }
        }
    }
}

