/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.dialog;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.dialog.Messages;
import com.archimatetool.editor.diagram.dialog.NestedConnectionInfo;
import com.archimatetool.editor.preferences.ConnectionPreferences;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class NewNestedRelationsDialog
extends ExtendedTitleAreaDialog
implements Listener {
    private String HELP_ID = "com.archimatetool.help.NewNestedRelationsDialog";
    private TableViewer fTableViewer;
    private IDiagramModelArchimateObject fParentObject;
    private Mapping[] fMappings;
    private boolean fModKeyPressed;

    public NewNestedRelationsDialog(IDiagramModelArchimateObject parentObject, List<IDiagramModelArchimateObject> childObjects) {
        super(Display.getCurrent().getActiveShell(), "NewNestedRelationsDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/new_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fParentObject = parentObject;
        this.fMappings = new Mapping[childObjects.size()];
        int i = 0;
        while (i < this.fMappings.length) {
            this.fMappings[i] = new Mapping(childObjects.get(i));
            ++i;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.NewNestedRelationsDialog_1);
        shell.getDisplay().addFilter(1, (Listener)this);
        shell.getDisplay().addFilter(2, (Listener)this);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 1: {
                if (event.keyCode != SWT.MOD1) break;
                this.fModKeyPressed = true;
                break;
            }
            case 2: {
                if (event.keyCode != SWT.MOD1) break;
                this.fModKeyPressed = false;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.HELP_ID);
        this.setTitle(Messages.NewNestedRelationsDialog_2);
        String message = NLS.bind((String)Messages.NewNestedRelationsDialog_3, (Object)this.fParentObject.getName());
        this.setMessage(message);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite client = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        Composite tableComp = new Composite(client, 2048);
        tableComp.setLayout((Layout)new TableColumnLayout());
        tableComp.setLayoutData((Object)new GridData(1808));
        this.fTableViewer = new RelationsTableViewer(tableComp, 0);
        this.fTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.setInput((Object)"");
        return composite;
    }

    public List<NestedConnectionInfo> getSelected() {
        ArrayList<NestedConnectionInfo> list = new ArrayList<NestedConnectionInfo>();
        Mapping[] mappingArray = this.fMappings;
        int n = this.fMappings.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping mapping = mappingArray[n2];
            if (mapping.getSelected().getRelationshipType() != null) {
                list.add(mapping.getSelected());
            }
            ++n2;
        }
        return list;
    }

    public boolean close() {
        this.getShell().getDisplay().removeFilter(1, (Listener)this);
        this.getShell().getDisplay().removeFilter(2, (Listener)this);
        this.fTableViewer.applyEditorValue();
        return super.close();
    }

    @Override
    protected Point getDefaultDialogSize() {
        return new Point(600, 400);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(1).setText(Messages.NewNestedRelationsDialog_8);
    }

    private class Mapping {
        private List<NestedConnectionInfo> validRelations;
        private String[] names;
        private int selectedIndex;

        Mapping(IDiagramModelArchimateObject childObject) {
            this.validRelations = this.createValidRelations(NewNestedRelationsDialog.this.fParentObject, childObject);
            this.selectedIndex = this.validRelations.size() > 1 ? 1 : 0;
        }

        String getSelectedRelationName() {
            return this.getValidRelationNames()[this.selectedIndex];
        }

        void setSelectedIndex(int value) {
            this.selectedIndex = value;
        }

        int getSelectedIndex() {
            return this.selectedIndex;
        }

        NestedConnectionInfo getSelected() {
            return this.validRelations.get(this.selectedIndex);
        }

        void setSelected(NestedConnectionInfo selected) {
            for (NestedConnectionInfo info : this.validRelations) {
                if (info.getRelationshipType() != selected.getRelationshipType() || info.getSourceObject() != selected.getSourceObject() && info.getTargetObject() != selected.getTargetObject()) continue;
                int index = this.validRelations.indexOf(info);
                this.selectedIndex = index == -1 ? 0 : index;
                break;
            }
        }

        String[] getValidRelationNames() {
            if (this.names == null) {
                this.names = new String[this.validRelations.size()];
                this.names[0] = Messages.NewNestedRelationsDialog_0;
                int i = 1;
                while (i < this.validRelations.size()) {
                    NestedConnectionInfo info = this.validRelations.get(i);
                    String relationshipName = ArchiLabelProvider.INSTANCE.getDefaultName(info.getRelationshipType());
                    String reverse = info.isReverse() ? Messages.NewNestedRelationsDialog_6 : "";
                    String sentence = ArchiLabelProvider.INSTANCE.getRelationshipSentence(info.getRelationshipType(), (IArchimateConcept)info.getSourceObject().getArchimateConcept(), (IArchimateConcept)info.getTargetObject().getArchimateConcept());
                    this.names[i] = NLS.bind((String)Messages.NewNestedRelationsDialog_7, (Object[])new Object[]{relationshipName, reverse, sentence});
                    ++i;
                }
            }
            return this.names;
        }

        private List<NestedConnectionInfo> createValidRelations(IDiagramModelArchimateObject sourceObject, IDiagramModelArchimateObject targetObject) {
            ArrayList<NestedConnectionInfo> list = new ArrayList<NestedConnectionInfo>();
            list.add(new NestedConnectionInfo(sourceObject, targetObject, false, null));
            for (EClass eClass : ConnectionPreferences.getRelationsClassesForNewRelations()) {
                if (!this.isAllowedRelationInViewpoint((IDiagramModelArchimateComponent)sourceObject, eClass) || !ArchimateModelUtils.isValidRelationship((IArchimateConcept)sourceObject.getArchimateElement(), (IArchimateConcept)targetObject.getArchimateElement(), (EClass)eClass)) continue;
                list.add(new NestedConnectionInfo(sourceObject, targetObject, false, eClass));
            }
            for (EClass eClass : ConnectionPreferences.getRelationsClassesForNewReverseRelations()) {
                if (!this.isAllowedRelationInViewpoint((IDiagramModelArchimateComponent)targetObject, eClass) || !ArchimateModelUtils.isValidRelationship((IArchimateConcept)targetObject.getArchimateElement(), (IArchimateConcept)sourceObject.getArchimateElement(), (EClass)eClass)) continue;
                list.add(new NestedConnectionInfo(targetObject, sourceObject, true, eClass));
            }
            return list;
        }

        private boolean isAllowedRelationInViewpoint(IDiagramModelArchimateComponent dmc, EClass type) {
            if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewpointsHidePaletteElements")) {
                return true;
            }
            return ViewpointManager.INSTANCE.isAllowedConceptForDiagramModel((IArchimateDiagramModel)dmc.getDiagramModel(), type);
        }
    }

    private class RelationsTableViewer
    extends TableViewer {
        private String[] columnNames;

        RelationsTableViewer(Composite parent, int style) {
            super(parent, 0x10000 | style);
            this.columnNames = new String[]{Messages.NewNestedRelationsDialog_4, Messages.NewNestedRelationsDialog_5};
            this.setColumns(this.getTable());
            this.setContentProvider((IContentProvider)new RelationsTableViewerContentProvider());
            this.setLabelProvider((IBaseLabelProvider)new RelationsTableViewerLabelCellProvider());
        }

        private void setColumns(Table table) {
            table.setHeaderVisible(true);
            TableColumnLayout layout = (TableColumnLayout)this.getControl().getParent().getLayout();
            TableColumn c1 = new TableColumn(table, 0, 0);
            c1.setText(this.columnNames[0]);
            layout.setColumnData((Widget)c1, (ColumnLayoutData)new ColumnWeightData(50, true));
            TableViewerColumn c2 = new TableViewerColumn((TableViewer)this, 0);
            c2.getColumn().setText(this.columnNames[1]);
            layout.setColumnData((Widget)c2.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, true));
            c2.setEditingSupport((EditingSupport)new TableColumnEditingSupport((ColumnViewer)this));
            this.setColumnProperties(this.columnNames);
        }

        class RelationsTableViewerContentProvider
        implements IStructuredContentProvider {
            RelationsTableViewerContentProvider() {
            }

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                return ((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationsDialog.this.fMappings;
            }
        }

        class RelationsTableViewerLabelCellProvider
        extends LabelProvider
        implements ITableLabelProvider {
            RelationsTableViewerLabelCellProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ArchiLabelProvider.INSTANCE.getImage(((Mapping)element).getSelected().getTargetObject());
                }
                return ArchiLabelProvider.INSTANCE.getImage(((Mapping)element).getSelected().getRelationshipType());
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((Mapping)element).getSelected().getTargetObject().getName();
                }
                return ((Mapping)element).getSelectedRelationName();
            }
        }

        class TableColumnEditingSupport
        extends EditingSupport {
            ComboBoxCellEditor cellEditor;

            public TableColumnEditingSupport(ColumnViewer viewer) {
                super(viewer);
                this.cellEditor = new ComboBoxCellEditor((Composite)RelationsTableViewer.this.getTable(), new String[0], 8);
                this.cellEditor.setActivationStyle(1);
                ((CCombo)this.cellEditor.getControl()).setVisibleItemCount(11);
            }

            protected CellEditor getCellEditor(Object element) {
                this.cellEditor.setItems(((Mapping)element).getValidRelationNames());
                return this.cellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((Mapping)element).getSelectedIndex();
            }

            protected void setValue(Object element, Object value) {
                Integer index = (Integer)value;
                if (index == -1) {
                    return;
                }
                Mapping mapping = (Mapping)element;
                mapping.setSelectedIndex(index);
                this.getViewer().update((Object)mapping, null);
                if (((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationsDialog.this.fModKeyPressed) {
                    NestedConnectionInfo selectedInfo = mapping.getSelected();
                    Mapping[] mappingArray = ((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationsDialog.this.fMappings;
                    int n = ((RelationsTableViewer)RelationsTableViewer.this).NewNestedRelationsDialog.this.fMappings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Mapping m = mappingArray[n2];
                        if (m != mapping) {
                            m.setSelected(selectedInfo);
                            this.getViewer().update((Object)m, null);
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

