/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.directedit;

import com.archimatetool.editor.diagram.AbstractDiagramEditor;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.components.GlobalActionDisablementHandler;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractDirectEditManager
extends DirectEditManager {
    private GlobalActionDisablementHandler fGlobalActionHandler;
    private VerifyListener verifyListener;

    public AbstractDirectEditManager(GraphicalEditPart source, Class<?> editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
    }

    protected void initCellEditor() {
        this.fGlobalActionHandler = new GlobalActionDisablementHandler();
        this.fGlobalActionHandler.clearGlobalActions();
        UIUtils.applyInvalidCharacterFilter((Control)this.getTextControl());
        UIUtils.applyMacUndoBugFilter((Control)this.getTextControl());
        IEditorPart iEditorPart = ((DefaultEditDomain)this.getEditPart().getViewer().getEditDomain()).getEditorPart();
        if (iEditorPart instanceof AbstractDiagramEditor) {
            AbstractDiagramEditor editor = (AbstractDiagramEditor)iEditorPart;
            editor.deactivateContext();
        }
    }

    protected void setNormalised() {
        if (this.verifyListener == null) {
            this.verifyListener = new VerifyListener(){

                public void verifyText(VerifyEvent event) {
                    event.text = event.text.replaceAll("(\r\n|\r|\n)", "");
                }
            };
            this.getTextControl().addVerifyListener(this.verifyListener);
        }
    }

    protected Text getTextControl() {
        return (Text)this.getCellEditor().getControl();
    }

    protected void unhookListeners() {
        super.unhookListeners();
        if (this.verifyListener != null) {
            this.getTextControl().removeVerifyListener(this.verifyListener);
        }
    }

    protected void bringDown() {
        this.fGlobalActionHandler.restoreGlobalActions();
        IEditorPart iEditorPart = ((DefaultEditDomain)this.getEditPart().getViewer().getEditDomain()).getEditorPart();
        if (iEditorPart instanceof AbstractDiagramEditor) {
            AbstractDiagramEditor editor = (AbstractDiagramEditor)iEditorPart;
            editor.activateContext();
        }
        super.bringDown();
    }
}

