/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.directedit;

import com.archimatetool.editor.diagram.directedit.AbstractDirectEditManager;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public class LabelDirectEditManager
extends AbstractDirectEditManager {
    private VerifyListener verifyListener;
    private IFigure textFigure;
    private String initialText;

    public LabelDirectEditManager(GraphicalEditPart source, IFigure textFigure, String initialText) {
        super(source, TextCellEditor.class, null);
        this.textFigure = textFigure;
        this.initialText = initialText;
        this.setLocator(new TextCellEditorLocator());
    }

    @Override
    protected void initCellEditor() {
        super.initCellEditor();
        this.setNormalised();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String oldText = LabelDirectEditManager.this.getTextControl().getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end, oldText.length());
                GC gc = new GC((Drawable)LabelDirectEditManager.this.getTextControl());
                Point size = gc.textExtent(leftText + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = LabelDirectEditManager.this.getTextControl().computeSize(size.x, -1);
                } else {
                    size.x = size.y;
                }
                LabelDirectEditManager.this.getCellEditor().getControl().setSize(size.x, size.y);
            }
        };
        this.getTextControl().addVerifyListener(this.verifyListener);
        this.getCellEditor().setValue((Object)this.initialText);
        IFigure figure = this.getEditPart().getFigure();
        this.getTextControl().setFont(figure.getFont());
    }

    @Override
    protected void unhookListeners() {
        super.unhookListeners();
        this.getTextControl().removeVerifyListener(this.verifyListener);
        this.verifyListener = null;
    }

    class TextCellEditorLocator
    implements CellEditorLocator {
        TextCellEditorLocator() {
        }

        public void relocate(CellEditor celleditor) {
            Text text = LabelDirectEditManager.this.getTextControl();
            Point preferredSize = text.computeSize(-1, -1);
            Rectangle rect = LabelDirectEditManager.this.textFigure instanceof Label ? ((Label)LabelDirectEditManager.this.textFigure).getTextBounds().getCopy() : LabelDirectEditManager.this.textFigure.getBounds().getCopy();
            LabelDirectEditManager.this.textFigure.translateToAbsolute((Translatable)rect);
            if (text.getCharCount() > 1) {
                text.setBounds(rect.x - 1, rect.y - 1, preferredSize.x + 1, preferredSize.y + 1);
            } else {
                text.setBounds(rect.x - 1, rect.y - 1, preferredSize.y + 1, preferredSize.y + 1);
            }
        }
    }
}

