/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.directedit;

import com.archimatetool.editor.diagram.directedit.AbstractDirectEditManager;
import com.archimatetool.editor.diagram.figures.IDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.connections.IDiagramConnectionFigure;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.INameable;
import com.archimatetool.model.ITextAlignment;
import com.archimatetool.model.ITextContent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MultiLineTextDirectEditManager
extends AbstractDirectEditManager {
    private TraverseListener traverseListener;
    private boolean isSingleText;
    private IFigure referenceFigure;

    public MultiLineTextDirectEditManager(GraphicalEditPart source) {
        this(source, false);
    }

    public MultiLineTextDirectEditManager(GraphicalEditPart source, boolean isSingleText) {
        this(source, isSingleText, source.getFigure());
    }

    public MultiLineTextDirectEditManager(GraphicalEditPart source, boolean isSingleText, IFigure referenceFigure) {
        super(source, MultiLineCellEditor.class, null);
        this.isSingleText = isSingleText;
        this.referenceFigure = referenceFigure;
        this.setLocator(new MultiLineCellEditorLocator());
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        int alignment = 16384;
        if (this.getEditPart().getModel() instanceof ITextAlignment) {
            int ta = ((ITextAlignment)this.getEditPart().getModel()).getTextAlignment();
            if (ta == 2) {
                alignment = 0x1000000;
            } else if (ta == 4) {
                alignment = 131072;
            }
        }
        return new MultiLineCellEditor(composite, alignment);
    }

    @Override
    protected void initCellEditor() {
        super.initCellEditor();
        this.getTextControl().setFont(this.referenceFigure.getFont());
        Object model = this.getEditPart().getModel();
        String value = "";
        if (model instanceof ITextContent) {
            value = ((ITextContent)model).getContent();
        } else if (model instanceof INameable) {
            value = ((INameable)model).getName();
        }
        this.getCellEditor().setValue((Object)StringUtils.safeString(value));
        if (this.isSingleText) {
            this.setNormalised();
            this.traverseListener = new TraverseListener(){

                public void keyTraversed(TraverseEvent event) {
                    if (event.detail == 4 || event.detail == 8 || event.detail == 16) {
                        MultiLineTextDirectEditManager.this.commit();
                    }
                }
            };
            this.getTextControl().addTraverseListener(this.traverseListener);
        }
    }

    @Override
    protected void unhookListeners() {
        super.unhookListeners();
        if (this.traverseListener != null) {
            this.getTextControl().removeTraverseListener(this.traverseListener);
            this.traverseListener = null;
        }
    }

    class MultiLineCellEditor
    extends TextCellEditor {
        public MultiLineCellEditor(Composite composite, int style) {
            super(composite, 0x242 | style);
        }
    }

    private class MultiLineCellEditorLocator
    implements CellEditorLocator {
        private MultiLineCellEditorLocator() {
        }

        public void relocate(CellEditor celleditor) {
            Text text = MultiLineTextDirectEditManager.this.getTextControl();
            Rectangle rect = MultiLineTextDirectEditManager.this.referenceFigure.getBounds().getCopy();
            MultiLineTextDirectEditManager.this.referenceFigure.translateToAbsolute((Translatable)rect);
            if (MultiLineTextDirectEditManager.this.getEditPart().getFigure() instanceof IDiagramConnectionFigure) {
                if (MultiLineTextDirectEditManager.this.isSingleText) {
                    int trimWidth = text.computeTrim((int)0, (int)0, (int)0, (int)0).width;
                    rect.width += trimWidth;
                    if (rect.width < 100) {
                        rect.width = 100;
                    }
                    int height = text.computeSize((int)(rect.width - trimWidth), (int)-1).y;
                    text.setBounds(rect.x, rect.y, rect.width, height);
                } else {
                    Point preferredSize = text.computeSize(-1, -1);
                    text.setBounds(rect.x, rect.y, Math.max(150, rect.width), Math.max(60, preferredSize.y));
                }
            } else {
                rect.x += 5;
                if (MultiLineTextDirectEditManager.this.isSingleText) {
                    int height = text.computeSize((int)(rect.width - text.computeTrim((int)0, (int)0, (int)0, (int)0).width), (int)-1).y;
                    if (!(MultiLineTextDirectEditManager.this.referenceFigure instanceof Label)) {
                        height = Math.min(height, rect.height);
                        Rectangle textControlBounds = ((IDiagramModelObjectFigure)MultiLineTextDirectEditManager.this.referenceFigure).getTextControl().getBounds().getCopy();
                        ((IDiagramModelObjectFigure)MultiLineTextDirectEditManager.this.referenceFigure).getTextControl().translateToAbsolute((Translatable)textControlBounds);
                        rect.y = textControlBounds.y;
                    }
                    rect.height = height;
                } else {
                    rect.y += 5;
                }
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

