/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.editparts.AbstractConnectedEditPart;
import com.archimatetool.editor.diagram.policies.ArchimateDiagramConnectionPolicy;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IFeatures;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.util.LightweightEContentAdapter;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractArchimateElementEditPart
extends AbstractConnectedEditPart {
    private Adapter adapter = new LightweightEContentAdapter(this::eCoreChanged, new Class[]{IProfile.class});
    private IArchimateModel fModel;

    protected AbstractArchimateElementEditPart() {
    }

    protected AbstractArchimateElementEditPart(Class<?> figureClass) {
        super(figureClass);
    }

    public IDiagramModelArchimateObject getModel() {
        return (IDiagramModelArchimateObject)super.getModel();
    }

    @Override
    protected void addECoreAdapter() {
        super.addECoreAdapter();
        this.getModel().getArchimateElement().eAdapters().add((Object)this.getECoreAdapter());
        this.fModel = this.getModel().getArchimateModel();
        this.fModel.eAdapters().add((Object)this.adapter);
    }

    @Override
    protected void removeECoreAdapter() {
        super.removeECoreAdapter();
        this.getModel().getArchimateElement().eAdapters().remove((Object)this.getECoreAdapter());
        if (this.fModel != null) {
            this.fModel.eAdapters().remove((Object)this.adapter);
            this.fModel = null;
        }
    }

    @Override
    protected void eCoreChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (IFeatures.isFeatureNotification((Notification)msg, (String)"hideJunctionArrows")) {
            for (Object o : this.getTargetConnections()) {
                ((EditPart)o).refresh();
            }
            for (Object o : this.getSourceConnections()) {
                ((EditPart)o).refresh();
            }
            return;
        }
        if (IFeatures.isFeatureNotification((Notification)msg) || feature == IArchimatePackage.Literals.PROFILES__PROFILES || feature == IArchimatePackage.Literals.ARCHIMATE_MODEL__PROFILES) {
            this.refreshFigure();
            return;
        }
        if (feature == IArchimatePackage.Literals.DIAGRAM_MODEL_ARCHIMATE_OBJECT__TYPE && msg.getNotifier() == this.getModel()) {
            this.refreshConnectionAnchors();
            this.refreshFigure();
            return;
        }
        switch (msg.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.refreshSourceConnections();
                this.refreshTargetConnections();
                this.refreshRelatedConnections();
                this.refreshChildren();
                break;
            }
            default: {
                super.eCoreChanged(msg);
            }
        }
    }

    protected void refreshRelatedConnections() {
        Map editPartRegistry = this.getRoot().getViewer().getEditPartRegistry();
        for (IDiagramModelObject dmo : this.getObjectsToUpdateConnections((IConnectable)this.getModel())) {
            Object v = editPartRegistry.get(dmo);
            if (!(v instanceof AbstractConnectedEditPart)) continue;
            AbstractConnectedEditPart editPart = (AbstractConnectedEditPart)((Object)v);
            editPart.refreshSourceConnections();
            editPart.refreshTargetConnections();
        }
    }

    protected Set<IDiagramModelObject> getObjectsToUpdateConnections(IConnectable connectable) {
        HashSet<IDiagramModelObject> set = new HashSet<IDiagramModelObject>();
        HashSet connections = new HashSet(connectable.getSourceConnections());
        connections.addAll(connectable.getTargetConnections());
        for (IDiagramModelConnection connection : connections) {
            IDiagramModelObject dmo;
            IConnectable iConnectable;
            IDiagramModelObject dmo2;
            IConnectable iConnectable2 = connection.getSource();
            if (iConnectable2 instanceof IDiagramModelObject && (dmo2 = (IDiagramModelObject)iConnectable2) != this.getModel()) {
                set.add(dmo2);
            }
            if ((iConnectable = connection.getTarget()) instanceof IDiagramModelObject && (dmo = (IDiagramModelObject)iConnectable) != this.getModel()) {
                set.add(dmo);
            }
            set.addAll(this.getObjectsToUpdateConnections((IConnectable)connection));
        }
        return set;
    }

    @Override
    protected void refreshFigure() {
        if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewpointsGhostDiagramElements")) {
            this.getFigure().setEnabled(ViewpointManager.INSTANCE.isAllowedDiagramModelComponent((IDiagramModelArchimateComponent)this.getModel()));
        } else {
            this.getFigure().setEnabled(true);
        }
        this.getFigure().refreshVisuals();
    }

    @Override
    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
        if ("viewpointsGhostDiagramElements".equals(event.getProperty())) {
            this.refreshFigure();
        } else {
            super.applicationPreferencesChanged(event);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ArchimateDiagramConnectionPolicy());
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (this.getModel() != null && this.getModel().getArchimateElement() != null && adapter.isInstance(this.getModel().getArchimateElement())) {
            return adapter.cast(this.getModel().getArchimateElement());
        }
        return super.getAdapter(adapter);
    }
}

