/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts;

import com.archimatetool.editor.diagram.directedit.MultiLineTextDirectEditManager;
import com.archimatetool.editor.diagram.editparts.AbstractArchimateElementEditPart;
import com.archimatetool.editor.diagram.editparts.SnapEditPartAdapter;
import com.archimatetool.editor.diagram.figures.IContainerFigure;
import com.archimatetool.editor.diagram.policies.ArchimateContainerLayoutPolicy;
import com.archimatetool.editor.diagram.policies.ArchimateDNDEditPolicy;
import com.archimatetool.editor.diagram.policies.BasicContainerEditPolicy;
import com.archimatetool.editor.diagram.policies.ContainerHighlightEditPolicy;
import com.archimatetool.editor.diagram.policies.PartComponentEditPolicy;
import com.archimatetool.editor.diagram.policies.PartDirectEditTitlePolicy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.tools.DirectEditManager;

public class ArchimateElementEditPart
extends AbstractArchimateElementEditPart {
    public ArchimateElementEditPart() {
    }

    public ArchimateElementEditPart(Class<?> figureClass) {
        super(figureClass);
    }

    public IFigure getContentPane() {
        return ((IContainerFigure)((Object)this.getFigure())).getContentPane();
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new PartDirectEditTitlePolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PartComponentEditPolicy());
        this.installEditPolicy("DND", (EditPolicy)new ArchimateDNDEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ArchimateContainerLayoutPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new BasicContainerEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ContainerHighlightEditPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            if (request instanceof LocationRequest) {
                if (this.getFigure().didClickTextControl(((LocationRequest)request).getLocation().getCopy())) {
                    this.createDirectEditManager().show();
                } else if (request.getType() == "open") {
                    this.showPropertiesView();
                }
            } else {
                this.createDirectEditManager().show();
            }
        }
    }

    protected DirectEditManager createDirectEditManager() {
        return new MultiLineTextDirectEditManager((GraphicalEditPart)this, true);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == SnapToHelper.class) {
            return adapter.cast(new SnapEditPartAdapter((GraphicalEditPart)this).getSnapToHelper());
        }
        return super.getAdapter(adapter);
    }
}

