/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts;

import com.archimatetool.editor.diagram.editparts.DiagramConnectionEditPart;
import com.archimatetool.editor.diagram.editparts.IConnectionEditPartFilter;
import com.archimatetool.editor.diagram.editparts.IEditPartFilterProvider;
import com.archimatetool.editor.diagram.editparts.LineConnectionAnchor;
import com.archimatetool.editor.diagram.policies.ArchimateDiagramConnectionPolicy;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ArchimateRelationshipEditPart
extends DiagramConnectionEditPart
implements NodeEditPart {
    public ArchimateRelationshipEditPart(Class<?> figureClass) {
        super(figureClass);
    }

    @Override
    protected void eCoreChanged(Notification msg) {
        Object feature = msg.getFeature();
        switch (msg.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (feature == IArchimatePackage.Literals.CONNECTABLE__SOURCE_CONNECTIONS) {
                    this.refreshSourceConnections();
                    break;
                }
                if (feature != IArchimatePackage.Literals.CONNECTABLE__TARGET_CONNECTIONS) break;
                this.refreshTargetConnections();
            }
        }
        super.eCoreChanged(msg);
    }

    @Override
    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
        if ("hiddenRelationsTypes".equals(event.getProperty()) || "useNestedConnections".equals(event.getProperty())) {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        } else {
            super.applicationPreferencesChanged(event);
        }
    }

    public IDiagramModelArchimateConnection getModel() {
        return (IDiagramModelArchimateConnection)super.getModel();
    }

    @Override
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().getArchimateRelationship().eAdapters().add((Object)this.getECoreAdapter());
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().getArchimateRelationship().eAdapters().remove((Object)this.getECoreAdapter());
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (this.getModel() != null && this.getModel().getArchimateRelationship() != null && adapter.isInstance(this.getModel().getArchimateRelationship())) {
            return adapter.cast(this.getModel().getArchimateRelationship());
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ArchimateDiagramConnectionPolicy());
    }

    protected List<IDiagramModelConnection> getModelSourceConnections() {
        return this.getFilteredModelSourceConnections();
    }

    protected List<IDiagramModelConnection> getModelTargetConnections() {
        return this.getFilteredModelTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new LineConnectionAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new LineConnectionAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            return null;
        }
        return new LineConnectionAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            return null;
        }
        return new LineConnectionAnchor(this.getFigure());
    }

    public List<IDiagramModelConnection> getFilteredModelSourceConnections() {
        return this.getFilteredConnections((List<IDiagramModelConnection>)this.getModel().getSourceConnections());
    }

    public List<IDiagramModelConnection> getFilteredModelTargetConnections() {
        return this.getFilteredConnections((List<IDiagramModelConnection>)this.getModel().getTargetConnections());
    }

    private List<IDiagramModelConnection> getFilteredConnections(List<IDiagramModelConnection> originalList) {
        IEditPartFilterProvider filterProvider = this.getRootEditPartFilterProvider();
        if (filterProvider == null) {
            return originalList;
        }
        IConnectionEditPartFilter[] filters = this.getRootEditPartFilterProvider().getEditPartFilters(IConnectionEditPartFilter.class);
        if (filters != null) {
            ArrayList<IDiagramModelConnection> filteredList = new ArrayList<IDiagramModelConnection>();
            for (IDiagramModelConnection connection : originalList) {
                boolean add = true;
                IConnectionEditPartFilter[] iConnectionEditPartFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IConnectionEditPartFilter filter = iConnectionEditPartFilterArray[n2];
                    add = filter.isConnectionVisible((EditPart)this, connection);
                    if (!add) break;
                    ++n2;
                }
                if (!add) continue;
                filteredList.add(connection);
            }
            return filteredList;
        }
        return originalList;
    }

    protected IEditPartFilterProvider getRootEditPartFilterProvider() {
        if (this.getRoot() != null && this.getRoot().getContents() instanceof IEditPartFilterProvider) {
            return (IEditPartFilterProvider)this.getRoot().getContents();
        }
        return null;
    }
}

