/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.commands.DiagramCommandFactory;
import com.archimatetool.editor.diagram.directedit.MultiLineTextDirectEditManager;
import com.archimatetool.editor.diagram.editparts.Messages;
import com.archimatetool.editor.diagram.figures.connections.IDiagramConnectionFigure;
import com.archimatetool.editor.diagram.policies.ManualBendpointEditPolicy;
import com.archimatetool.editor.diagram.policies.SelectedEditPartPolicy;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.ui.services.ViewManager;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelBendpoint;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IFeature;
import com.archimatetool.model.ILockable;
import com.archimatetool.model.util.LightweightEContentAdapter;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class DiagramConnectionEditPart
extends AbstractConnectionEditPart {
    private Adapter adapter = new LightweightEContentAdapter(this::eCoreChanged, new Class[]{IFeature.class});
    private IPropertyChangeListener prefsListener = event -> this.applicationPreferencesChanged(event);
    private PropertyChangeListener figureListener = event -> {
        String property = event.getPropertyName();
        if ("connectionRouter".equals(property)) {
            this.refreshBendpoints();
            this.refreshBendpointEditPolicy();
        }
    };
    protected Class<?> figureClass;

    public DiagramConnectionEditPart() {
    }

    public DiagramConnectionEditPart(Class<?> figureClass) {
        assert (IDiagramConnectionFigure.class.isAssignableFrom(figureClass));
        this.figureClass = figureClass;
    }

    protected IFigure createFigure() {
        IDiagramConnectionFigure figure = null;
        if (this.figureClass != null) {
            try {
                figure = (IDiagramConnectionFigure)this.figureClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                figure.setModelConnection(this.getModel());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return figure;
    }

    protected void eCoreChanged(Notification msg) {
        Object feature = msg.getFeature();
        switch (msg.getEventType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
                    this.createEditPolicies();
                    break;
                }
                this.refreshVisuals();
                break;
            }
        }
    }

    protected Adapter getECoreAdapter() {
        return this.adapter;
    }

    protected void addECoreAdapter() {
        if (this.getECoreAdapter() != null) {
            this.getModel().eAdapters().add((Object)this.getECoreAdapter());
        }
    }

    protected void removeECoreAdapter() {
        if (this.getECoreAdapter() != null) {
            this.getModel().eAdapters().remove((Object)this.getECoreAdapter());
        }
    }

    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("defaultViewFont".equals(property)) {
            this.getFigure().refreshVisuals();
        } else if (property.equals("defaultConnectionLineColor")) {
            this.getFigure().refreshVisuals();
        } else if ("lineCurves".equals(property)) {
            this.getFigure().repaint();
        } else if ("lineJumps".equals(property)) {
            this.getFigure().repaint();
        } else if ("connectionLabelStrategy".equals(property)) {
            this.getFigure().refreshVisuals();
        } else if ("viewpointsGhostDiagramElements".equals(property)) {
            this.getFigure().refreshVisuals();
        } else if ("fontScaling".equals(property)) {
            this.getFigure().refreshVisuals();
        }
    }

    public IDiagramModelConnection getModel() {
        return (IDiagramModelConnection)super.getModel();
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.addECoreAdapter();
            ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.prefsListener);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.removeECoreAdapter();
            ArchiPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.prefsListener);
        }
    }

    public void activateFigure() {
        super.activateFigure();
        this.getFigure().addPropertyChangeListener("connectionRouter", this.figureListener);
    }

    public void deactivateFigure() {
        this.getFigure().removePropertyChangeListener("connectionRouter", this.figureListener);
        super.deactivateFigure();
    }

    public IDiagramConnectionFigure getFigure() {
        return (IDiagramConnectionFigure)super.getFigure();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            if (request instanceof LocationRequest) {
                LocationRequest locationRequest = (LocationRequest)request;
                if (!this.isLocked() && this.getFigure().didClickConnectionLabel(locationRequest.getLocation().getCopy())) {
                    this.createDirectEditManager().show();
                } else if (request.getType() == "open") {
                    this.showPropertiesView();
                }
            } else {
                this.createDirectEditManager().show();
            }
        }
    }

    protected DirectEditManager createDirectEditManager() {
        return new MultiLineTextDirectEditManager((GraphicalEditPart)this, true, (IFigure)this.getFigure().getConnectionLabel());
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)(this.isLocked() ? null : new ConnectionEndpointEditPolicy()));
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)(this.isLocked() ? null : new ConnectionDirectEditTextPolicy()));
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)(this.isLocked() ? null : new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return DiagramCommandFactory.createDeleteDiagramConnectionCommand(DiagramConnectionEditPart.this.getModel());
            }
        }));
        this.refreshBendpointEditPolicy();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectedEditPartPolicy(true));
    }

    protected void refreshVisuals() {
        this.getFigure().refreshVisuals();
        this.refreshBendpoints();
    }

    protected boolean isLocked() {
        ILockable lockable;
        IDiagramModelConnection iDiagramModelConnection = this.getModel();
        return iDiagramModelConnection instanceof ILockable && (lockable = (ILockable)iDiagramModelConnection).isLocked();
    }

    protected void refreshBendpoints() {
        if (this.getConnectionFigure().getConnectionRouter() instanceof ManhattanConnectionRouter) {
            return;
        }
        ArrayList<RelativeBendpoint> figureConstraint = new ArrayList<RelativeBendpoint>();
        EList bendpoints = this.getModel().getBendpoints();
        int i = 0;
        while (i < bendpoints.size()) {
            IDiagramModelBendpoint bendpoint = (IDiagramModelBendpoint)bendpoints.get(i);
            RelativeBendpoint rbp = new RelativeBendpoint(this.getConnectionFigure());
            Dimension dim1 = new Dimension(bendpoint.getStartX(), bendpoint.getStartY());
            Dimension dim2 = new Dimension(bendpoint.getEndX(), bendpoint.getEndY());
            rbp.setRelativeDimensions(dim1, dim2);
            rbp.setWeight((float)(i + 1) / ((float)bendpoints.size() + 1.0f));
            figureConstraint.add(rbp);
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    protected void refreshBendpointEditPolicy() {
        if (this.isLocked()) {
            this.installEditPolicy("Connection Bendpoint Policy", null);
        } else if (this.getConnectionFigure().getConnectionRouter() instanceof ManhattanConnectionRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", null);
        } else {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ManualBendpointEditPolicy());
        }
    }

    protected void showPropertiesView() {
        ViewManager.showViewPart(ViewManager.PROPERTIES_VIEW, false);
    }

    protected ZoomManager getZoomManager() {
        return (ZoomManager)this.getViewer().getProperty(ZoomManager.class.toString());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.getModel() != null && adapter.isInstance(this.getModel())) {
            return adapter.cast(this.getModel());
        }
        return (T)super.getAdapter(adapter);
    }

    protected class ConnectionDirectEditTextPolicy
    extends DirectEditPolicy {
        protected Command getDirectEditCommand(DirectEditRequest request) {
            String name = (String)request.getCellEditor().getValue();
            IDiagramModelConnection connection = DiagramConnectionEditPart.this.getModel();
            return new EObjectFeatureCommand(Messages.DiagramConnectionEditPart_0, (EObject)connection, (EStructuralFeature)IArchimatePackage.Literals.NAMEABLE__NAME, name);
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

