/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.FigureUtils;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.IRoundedRectangleFigure;
import com.archimatetool.editor.diagram.figures.elements.ValueFigure;
import com.archimatetool.model.IDiagramModelArchimateObject;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class OrthogonalAnchor
extends ChopboxAnchor {
    private static final int RECONREQ_SRC = 1;
    private static final int RECONREQ_TGT = 2;
    private static final int CRCONREQ_SRC = 3;
    private static final int CRCONREQ_TGT = 4;
    private static final int CONNECTION_SRC = 5;
    private static final int CONNECTION_TGT = 6;
    private static final int LEFT = 1;
    private static final int LEFT_CORNER = 2;
    private static final int MIDDLE = 4;
    private static final int RIGHT_CORNER = 8;
    private static final int RIGHT = 16;
    private static final int TOP = 32;
    private static final int TOP_CORNER = 64;
    private static final int CENTER = 128;
    private static final int BOTTOM_CORNER = 256;
    private static final int BOTTOM = 512;
    private static final double COSPI4 = Math.cos(0.7853981633974483);
    private ConnectionEditPart fAnchorConnection = null;
    private Request fRequest = null;
    private IFigure fRemoteFig = null;
    private IFigure fAlternateRemoteFig = null;
    private int fAnchorType = 0;

    public OrthogonalAnchor(IFigure owner, ConnectionEditPart connection, boolean isSource) {
        super(owner);
        this.fAnchorConnection = connection;
        this.fAnchorType = isSource ? 5 : 6;
    }

    public OrthogonalAnchor(IFigure owner, Request request, boolean isSource) {
        super(owner);
        this.fRequest = request;
        if (request instanceof CreateConnectionRequest) {
            this.fAnchorType = isSource ? 3 : 4;
        } else if (request instanceof ReconnectRequest) {
            this.fAnchorType = isSource ? 1 : 2;
        }
    }

    public void setAlternateRemoteFig(IFigure figure) {
        this.fAlternateRemoteFig = figure;
    }

    public Point getLocation(Point reference) {
        Rectangle remoteFigCenter;
        IFigure remoteFig = null;
        Rectangle remoteFigBBox = new Rectangle();
        Rectangle figureBBox = new Rectangle();
        boolean inFigure = false;
        figureBBox.setBounds(this.getBox());
        this.getOwner().translateToAbsolute((Translatable)figureBBox);
        this.updateRemoteFig();
        if (this.fRemoteFig != null) {
            remoteFig = this.fRemoteFig;
            remoteFigBBox.setBounds(remoteFig.getBounds());
            remoteFig.translateToAbsolute((Translatable)remoteFigBBox);
            remoteFigCenter = remoteFigBBox.getCopy();
            remoteFigCenter.shrink((remoteFigCenter.width - 5) / 2, (remoteFigCenter.height - 5) / 2);
            inFigure = remoteFigCenter.contains(reference);
        }
        if (!inFigure && this.fAlternateRemoteFig != null) {
            remoteFig = this.fAlternateRemoteFig;
            remoteFigBBox.setBounds(remoteFig.getBounds());
            remoteFig.translateToAbsolute((Translatable)remoteFigBBox);
            remoteFigCenter = remoteFigBBox.getCopy();
            remoteFigCenter.shrink((remoteFigCenter.width - 5) / 2, (remoteFigCenter.height - 5) / 2);
            inFigure = remoteFigCenter.contains(reference);
        }
        if (inFigure) {
            reference.x = (Math.max(remoteFigBBox.x, figureBBox.x) + Math.min(remoteFigBBox.x + remoteFigBBox.width, figureBBox.x + figureBBox.width)) / 2;
            reference.y = (Math.max(remoteFigBBox.y, figureBBox.y) + Math.min(remoteFigBBox.y + remoteFigBBox.height, figureBBox.y + figureBBox.height)) / 2;
        }
        int pos = 0;
        Dimension corner = this.getCornerDimensions(this.getOwner());
        corner = corner.scale(FigureUtils.getFigureScale(this.getOwner()));
        pos = reference.x < figureBBox.x ? 1 : (reference.x < figureBBox.x + corner.width / 2 ? 2 : (reference.x < figureBBox.x + figureBBox.width - corner.width / 2 ? 4 : (reference.x < figureBBox.x + figureBBox.width ? 8 : 16)));
        pos = reference.y < figureBBox.y ? (pos |= 0x20) : (reference.y < figureBBox.y + corner.height / 2 ? (pos |= 0x40) : (reference.y < figureBBox.y + figureBBox.height - corner.height / 2 ? (pos |= 0x80) : (reference.y < figureBBox.y + figureBBox.height ? (pos |= 0x100) : (pos |= 0x200))));
        figureBBox.resize(-1, -1);
        switch (pos) {
            case 33: {
                return new Point(figureBBox.x + corner.width / 2 - (int)(COSPI4 * ((double)corner.width / 2.0)), figureBBox.y + corner.height / 2 - (int)(COSPI4 * ((double)corner.height / 2.0)));
            }
            case 34: {
                return new Point(reference.x, figureBBox.y + corner.height / 2 - (int)(Math.sin(Math.acos(((double)figureBBox.x + (double)corner.width / 2.0 - (double)reference.x) / ((double)corner.width / 2.0))) * ((double)corner.height / 2.0)));
            }
            case 36: {
                return new Point(reference.x, figureBBox.y);
            }
            case 40: {
                return new Point(reference.x, figureBBox.y + corner.height / 2 - (int)(Math.sin(Math.acos(((double)(figureBBox.x + figureBBox.width) - (double)corner.width / 2.0 - (double)reference.x) / ((double)corner.width / 2.0))) * ((double)corner.height / 2.0)));
            }
            case 48: {
                return new Point(figureBBox.x + figureBBox.width - corner.width / 2 + (int)(COSPI4 * ((double)corner.width / 2.0)), figureBBox.y + corner.height / 2 - (int)(COSPI4 * ((double)corner.height / 2.0)));
            }
            case 65: {
                return new Point(figureBBox.x + corner.width / 2 - (int)(Math.cos(Math.asin(((double)figureBBox.y + (double)corner.height / 2.0 - (double)reference.y) / ((double)corner.height / 2.0))) * ((double)corner.width / 2.0)), reference.y);
            }
            case 80: {
                return new Point(figureBBox.x + figureBBox.width - corner.width / 2 + (int)(Math.cos(Math.asin(((double)figureBBox.y + (double)corner.height / 2.0 - (double)reference.y) / ((double)corner.height / 2.0))) * ((double)corner.width / 2.0)), reference.y);
            }
            case 129: {
                return new Point(figureBBox.x, reference.y);
            }
            case 144: {
                return new Point(figureBBox.x + figureBBox.width, reference.y);
            }
            case 257: {
                return new Point(figureBBox.x + corner.width / 2 - (int)(Math.cos(Math.asin(((double)(figureBBox.y + figureBBox.height) - (double)corner.height / 2.0 - (double)reference.y) / ((double)corner.height / 2.0))) * ((double)corner.width / 2.0)), reference.y);
            }
            case 272: {
                return new Point(figureBBox.x + figureBBox.width - corner.width / 2 + (int)(Math.cos(Math.asin(((double)(figureBBox.y + figureBBox.height) - (double)corner.height / 2.0 - (double)reference.y) / ((double)corner.height / 2.0))) * ((double)corner.width / 2.0)), reference.y);
            }
            case 513: {
                return new Point(figureBBox.x + corner.width / 2 - (int)(COSPI4 * ((double)corner.width / 2.0)), figureBBox.y + figureBBox.height - corner.height / 2 + (int)(COSPI4 * ((double)corner.height / 2.0)));
            }
            case 514: {
                return new Point(reference.x, figureBBox.y + figureBBox.height - corner.height / 2 + (int)(Math.sin(Math.acos(((double)figureBBox.x + (double)corner.width / 2.0 - (double)reference.x) / ((double)corner.width / 2.0))) * ((double)corner.height / 2.0)));
            }
            case 516: {
                return new Point(reference.x, figureBBox.y + figureBBox.height);
            }
            case 520: {
                return new Point(reference.x, figureBBox.y + figureBBox.height - corner.height / 2 + (int)(Math.sin(Math.acos(((double)(figureBBox.x + figureBBox.width) - (double)corner.width / 2.0 - (double)reference.x) / ((double)corner.width / 2.0))) * ((double)corner.height / 2.0)));
            }
            case 528: {
                return new Point(figureBBox.x + figureBBox.width - corner.width / 2 + (int)(COSPI4 * ((double)corner.width / 2.0)), figureBBox.y + figureBBox.height - corner.height / 2 + (int)(COSPI4 * ((double)corner.height / 2.0)));
            }
        }
        return figureBBox.getCenter();
    }

    private void updateRemoteFig() {
        switch (this.fAnchorType) {
            case 3: {
                this.fRemoteFig = ((CreateConnectionRequest)this.fRequest).getTargetEditPart() != null ? ((GraphicalEditPart)((CreateConnectionRequest)this.fRequest).getTargetEditPart()).getFigure() : null;
                break;
            }
            case 4: {
                IFigure iFigure = this.fRemoteFig = ((CreateConnectionRequest)this.fRequest).getSourceEditPart() != null ? ((GraphicalEditPart)((CreateConnectionRequest)this.fRequest).getSourceEditPart()).getFigure() : null;
            }
        }
        if (this.fRemoteFig != null) {
            return;
        }
        switch (this.fAnchorType) {
            case 5: {
                this.fRemoteFig = this.fAnchorConnection != null && this.fAnchorConnection.getTarget() != null ? ((GraphicalEditPart)this.fAnchorConnection.getTarget()).getFigure() : null;
                break;
            }
            case 6: {
                this.fRemoteFig = this.fAnchorConnection != null && this.fAnchorConnection.getSource() != null ? ((GraphicalEditPart)this.fAnchorConnection.getSource()).getFigure() : null;
                break;
            }
            case 1: {
                IFigure iFigure = this.fRemoteFig = ((ReconnectRequest)this.fRequest).getConnectionEditPart().getTarget() != null ? ((GraphicalEditPart)((ReconnectRequest)this.fRequest).getConnectionEditPart().getTarget()).getFigure() : null;
                if (!(((Connection)((ReconnectRequest)this.fRequest).getConnectionEditPart().getFigure()).getTargetAnchor() instanceof OrthogonalAnchor)) break;
                ((OrthogonalAnchor)((Connection)((ReconnectRequest)this.fRequest).getConnectionEditPart().getFigure()).getTargetAnchor()).setAlternateRemoteFig(this.getOwner());
                break;
            }
            case 2: {
                IFigure iFigure = this.fRemoteFig = ((ReconnectRequest)this.fRequest).getConnectionEditPart().getSource() != null ? ((GraphicalEditPart)((ReconnectRequest)this.fRequest).getConnectionEditPart().getSource()).getFigure() : null;
                if (!(((Connection)((ReconnectRequest)this.fRequest).getConnectionEditPart().getFigure()).getSourceAnchor() instanceof OrthogonalAnchor)) break;
                ((OrthogonalAnchor)((Connection)((ReconnectRequest)this.fRequest).getConnectionEditPart().getFigure()).getSourceAnchor()).setAlternateRemoteFig(this.getOwner());
            }
        }
    }

    private Dimension getCornerDimensions(IFigure figure) {
        IFigureDelegate figureDelegate;
        Dimension corner = new Dimension(0, 0);
        if (figure instanceof AbstractDiagramModelObjectFigure && (figureDelegate = ((AbstractDiagramModelObjectFigure)figure).getFigureDelegate()) instanceof IRoundedRectangleFigure) {
            return ((IRoundedRectangleFigure)((Object)figureDelegate)).getArc();
        }
        if (figure instanceof IRoundedRectangleFigure) {
            corner = ((IRoundedRectangleFigure)figure).getArc();
        } else if (figure instanceof RoundedRectangle) {
            corner = ((RoundedRectangle)figure).getCornerDimensions();
        } else if (figure instanceof ValueFigure && ((IDiagramModelArchimateObject)((ValueFigure)figure).getDiagramModelObject()).getType() == 1) {
            corner = figure.getSize();
        }
        return corner;
    }
}

