/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts.diagram;

import com.archimatetool.editor.diagram.directedit.MultiLineTextDirectEditManager;
import com.archimatetool.editor.diagram.editparts.AbstractConnectedEditPart;
import com.archimatetool.editor.diagram.figures.diagram.DiagramModelReferenceFigure;
import com.archimatetool.editor.diagram.policies.ArchimateDiagramConnectionPolicy;
import com.archimatetool.editor.diagram.policies.PartComponentEditPolicy;
import com.archimatetool.editor.diagram.policies.PartDirectEditTitlePolicy;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.tools.DirectEditManager;

public class DiagramModelReferenceEditPart
extends AbstractConnectedEditPart {
    @Override
    protected void addECoreAdapter() {
        super.addECoreAdapter();
        IDiagramModel ref = this.getModel().getReferencedModel();
        if (ref != null) {
            ref.eAdapters().add((Object)this.getECoreAdapter());
        }
    }

    @Override
    protected void removeECoreAdapter() {
        super.removeECoreAdapter();
        IDiagramModel ref = this.getModel().getReferencedModel();
        if (ref != null) {
            ref.eAdapters().remove((Object)this.getECoreAdapter());
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ArchimateDiagramConnectionPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new PartDirectEditTitlePolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PartComponentEditPolicy());
    }

    @Override
    protected IFigure createFigure() {
        DiagramModelReferenceFigure figure = new DiagramModelReferenceFigure((IDiagramModelObject)this.getModel());
        return figure;
    }

    @Override
    protected void refreshFigure() {
        this.getFigure().refreshVisuals();
    }

    public IDiagramModelReference getModel() {
        return (IDiagramModelReference)super.getModel();
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            EditorManager.openDiagramEditor(this.getModel().getReferencedModel());
        } else if (request.getType() == "direct edit") {
            if (request instanceof LocationRequest) {
                if (this.getFigure().didClickTextControl(((LocationRequest)request).getLocation().getCopy())) {
                    this.createDirectEditManager().show();
                }
            } else {
                this.createDirectEditManager().show();
            }
        }
    }

    protected DirectEditManager createDirectEditManager() {
        return new MultiLineTextDirectEditManager((GraphicalEditPart)this, true);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (this.getModel() != null && this.getModel().getReferencedModel() != null && adapter.isInstance(this.getModel().getReferencedModel()) && !adapter.isInstance(this.getModel())) {
            return adapter.cast(this.getModel().getReferencedModel());
        }
        return super.getAdapter(adapter);
    }
}

