/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.IRoundedRectangleFigure;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Pattern;

public class RoundedRectangleFigureDelegate
extends RectangleFigureDelegate
implements IRoundedRectangleFigure {
    private Dimension fArc = new Dimension(20, 20);

    public RoundedRectangleFigureDelegate(AbstractDiagramModelObjectFigure owner) {
        super(owner);
    }

    @Override
    public void drawFigure(Graphics graphics) {
        boolean drawOutline;
        graphics.pushState();
        Rectangle bounds = this.getBounds();
        --bounds.width;
        --bounds.height;
        boolean bl = drawOutline = this.getLineStyle() != 3;
        if (drawOutline) {
            this.setLineWidth(graphics, bounds);
            this.setLineStyle(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillRoundRectangle(bounds, this.fArc.width, this.fArc.height);
        this.disposeGradientPattern(graphics, gradient);
        if (drawOutline) {
            graphics.setAlpha(this.getLineAlpha());
            graphics.setForegroundColor(this.getLineColor());
            graphics.drawRoundRectangle(bounds, this.fArc.width, this.fArc.height);
        }
        Rectangle imageArea = new Rectangle(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
        this.getOwner().drawIconImage(graphics, bounds, imageArea, 0, 0, 0, 0);
        graphics.popState();
    }

    @Override
    public void setArc(Dimension arc) {
        this.fArc.width = arc.width;
        this.fArc.height = arc.height;
    }

    @Override
    public Dimension getArc() {
        return this.fArc.getCopy();
    }
}

