/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.connections;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.figures.ToolTipFigure;
import com.archimatetool.editor.diagram.figures.connections.AbstractDiagramConnectionFigure;
import com.archimatetool.editor.diagram.figures.connections.IArchimateConnectionFigure;
import com.archimatetool.editor.diagram.figures.connections.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.viewpoints.ViewpointManager;
import org.eclipse.draw2d.IFigure;

public abstract class AbstractArchimateConnectionFigure
extends AbstractDiagramConnectionFigure
implements IArchimateConnectionFigure {
    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        boolean enabled = true;
        if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewpointsGhostDiagramElements")) {
            enabled = ViewpointManager.INSTANCE.isAllowedDiagramModelComponent((IDiagramModelArchimateComponent)this.getDiagramModelArchimateConnection());
        }
        this.setEnabled(enabled);
        if (this.getSourceDecoration() != null) {
            this.getSourceDecoration().setEnabled(enabled);
        }
        if (this.getTargetDecoration() != null) {
            this.getTargetDecoration().setEnabled(enabled);
        }
        this.getConnectionLabel().setEnabled(enabled);
        this.repaint();
    }

    @Override
    public IFigure getToolTip() {
        ToolTipFigure toolTipFigure = (ToolTipFigure)super.getToolTip();
        if (toolTipFigure == null) {
            return null;
        }
        IArchimateRelationship relation = this.getDiagramModelArchimateConnection().getArchimateRelationship();
        String text = ArchiLabelProvider.INSTANCE.getLabel(relation);
        toolTipFigure.setText(text);
        String type = ArchiLabelProvider.INSTANCE.getDefaultName(relation.eClass());
        toolTipFigure.setType(Messages.AbstractArchimateConnectionFigure_0 + " " + type);
        String rubric = ArchiLabelProvider.INSTANCE.getRelationshipSentence(relation);
        toolTipFigure.setRubric(rubric);
        return toolTipFigure;
    }

    protected boolean usePlainJunctionTargetDecoration() {
        IConnectable target = this.getModelConnection().getTarget();
        if (target instanceof IDiagramModelArchimateObject && ((IDiagramModelArchimateObject)target).getArchimateElement() instanceof IJunction) {
            return target.getFeatures().getBoolean("hideJunctionArrows", false);
        }
        return false;
    }

    protected boolean usePlainJunctionSourceDecoration() {
        IConnectable source = this.getModelConnection().getSource();
        if (source instanceof IDiagramModelArchimateObject && ((IDiagramModelArchimateObject)source).getArchimateElement() instanceof IJunction) {
            return source.getFeatures().getBoolean("hideJunctionArrows", false);
        }
        return false;
    }
}

