/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.connections;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.figures.ToolTipFigure;
import com.archimatetool.editor.diagram.figures.connections.ArchiConnectionEndpointLocator;
import com.archimatetool.editor.diagram.figures.connections.IDiagramConnectionFigure;
import com.archimatetool.editor.diagram.figures.connections.RoundedPolylineConnection;
import com.archimatetool.editor.diagram.util.AnimationUtil;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.FontFactory;
import com.archimatetool.editor.ui.textrender.TextRenderer;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IDiagramModelConnection;
import java.util.Arrays;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Path;

public abstract class AbstractDiagramConnectionFigure
extends RoundedPolylineConnection
implements IDiagramConnectionFigure {
    private TextFlow textFlow;
    private IDiagramModelConnection diagramModelConnection;
    protected int fTextPosition = -1;
    protected Color fFontColor;
    protected Color fLineColor;
    protected static Color highlightedColor = new Color(0, 0, 255);
    protected boolean isSelected = false;
    protected boolean showTargetFeedback = false;

    @Override
    public void setModelConnection(IDiagramModelConnection connection) {
        this.diagramModelConnection = connection;
        this.setFigureProperties();
        AnimationUtil.addConnectionForRoutingAnimation(this);
    }

    @Override
    public IDiagramModelConnection getModelConnection() {
        return this.diagramModelConnection;
    }

    protected void setFigureProperties() {
    }

    @Override
    public void refreshVisuals() {
        if (this.getModelConnection().getTextPosition() != this.fTextPosition) {
            this.fTextPosition = this.getModelConnection().getTextPosition();
            this.setLabelLocator(this.fTextPosition);
        }
        this.setLabelFont();
        this.setLabelFontColor();
        this.setLineColor();
        this.setText();
        this.setLineWidth();
        this.setTextAlignment(this.getModelConnection().getTextAlignment());
        this.getFlowPage().setOpaque(ArchiPlugin.getInstance().getPreferenceStore().getInt("connectionLabelStrategy") == 1);
        this.repaint();
    }

    @Override
    public boolean didClickConnectionLabel(Point requestLoc) {
        TextFlow label = this.getConnectionLabel();
        label.translateToRelative((Translatable)requestLoc);
        return label.containsPoint(requestLoc);
    }

    public TextFlow getConnectionLabel() {
        if (this.textFlow == null) {
            this.textFlow = new TextFlow();
            FlowPage flowPage = new FlowPage();
            flowPage.add((IFigure)this.textFlow);
            this.add((IFigure)flowPage);
        }
        return this.textFlow;
    }

    protected FlowPage getFlowPage() {
        return (FlowPage)this.getConnectionLabel().getParent();
    }

    protected void setTextAlignment(int alignment) {
        this.getFlowPage().setHorizontalAligment(alignment);
    }

    private void setLabelLocator(int position) {
        ArchiConnectionEndpointLocator locator = null;
        switch (position) {
            case 0: {
                locator = new ArchiConnectionEndpointLocator(this, false);
                break;
            }
            case 1: {
                locator = new ConnectionLocator((Connection)this, 4);
                break;
            }
            case 2: {
                locator = new ArchiConnectionEndpointLocator(this, true);
            }
        }
        this.setConstraint((IFigure)this.getFlowPage(), locator);
    }

    @Override
    public void setText() {
        String text = "";
        if (this.getModelConnection().isNameVisible()) {
            text = TextRenderer.getDefault().render((IArchimateModelObject)this.getModelConnection(), StringUtils.safeString(this.getModelConnection().getName().trim()));
        }
        this.getConnectionLabel().setText(text);
    }

    protected void setLabelFont() {
        this.getConnectionLabel().setFont(FontFactory.getScaledFont(this.getModelConnection().getFont()));
    }

    protected void setLabelFontColor() {
        String val = this.getModelConnection().getFontColor();
        Color c = ColorFactory.get(val);
        if (c == null) {
            c = ColorConstants.black;
        }
        if (c != this.fFontColor) {
            this.fFontColor = c;
            this.getConnectionLabel().setForegroundColor(c);
        }
    }

    protected void setLineColor() {
        String val = this.getModelConnection().getLineColor();
        Color color = ColorFactory.get(val);
        if (color == null) {
            color = ColorFactory.getDefaultLineColor(this.getModelConnection());
        }
        if (color != this.fLineColor) {
            this.fLineColor = color;
            this.setForegroundColor(color);
        }
    }

    protected void setLineWidth() {
        this.setLineWidth(this.getModelConnection().getLineWidth());
    }

    public IFigure getToolTip() {
        if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewTooltips")) {
            return null;
        }
        if (super.getToolTip() == null) {
            this.setToolTip((IFigure)new ToolTipFigure());
        }
        return super.getToolTip();
    }

    protected void fireFigureMoved() {
        float[] ld = this.getLineDashFloats();
        if (ld != null && !Arrays.equals(ld, this.getLineDash())) {
            this.setLineDash(ld);
        }
        super.fireFigureMoved();
    }

    protected float[] getLineDashFloats() {
        return null;
    }

    @Override
    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    @Override
    public void showTargetFeedback(boolean show) {
        this.showTargetFeedback = show;
    }

    public void paintFigure(Graphics graphics) {
        if (this.showTargetFeedback || this.isSelected && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("showSelectedConnections")) {
            this.setLineWidth(this.getModelConnection().getLineWidth() + 1);
            this.setForegroundColor(highlightedColor);
        } else {
            this.setLineWidth();
            this.setForegroundColor(this.fLineColor);
        }
        if (StringUtils.isSet(this.getConnectionLabel().getText()) && ArchiPlugin.getInstance().getPreferenceStore().getInt("connectionLabelStrategy") == 2) {
            this.clipTextLabel(graphics);
        } else {
            super.paintFigure(graphics);
        }
    }

    protected void clipTextLabel(Graphics graphics) {
        Rectangle g = graphics.getClip(new Rectangle());
        Rectangle l = this.getFlowPage().getBounds().getCopy();
        l.expand(1, 1);
        Path path = new Path(null);
        path.moveTo((float)g.x, (float)g.y);
        path.lineTo((float)l.x, (float)l.y);
        path.lineTo((float)(l.x + l.width), (float)l.y);
        path.lineTo((float)(l.x + l.width), (float)(l.y + l.height));
        path.lineTo((float)l.x, (float)(l.y + l.height));
        path.lineTo((float)l.x, (float)l.y);
        path.lineTo((float)g.x, (float)g.y);
        path.lineTo((float)g.x, (float)(g.y + g.height));
        path.lineTo((float)(g.x + g.width), (float)(g.y + g.height));
        path.lineTo((float)(g.x + g.width), (float)g.y);
        path.lineTo((float)g.x, (float)g.y);
        graphics.clipPath(path);
        super.paintFigure(graphics);
        path.dispose();
    }
}

