/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.connections;

import com.archimatetool.editor.diagram.figures.FigureUtils;
import com.archimatetool.editor.diagram.figures.ToolTipFigure;
import com.archimatetool.editor.diagram.figures.connections.AbstractArchimateConnectionFigure;
import com.archimatetool.editor.diagram.figures.connections.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.model.IAccessRelationship;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;

public class AccessConnectionFigure
extends AbstractArchimateConnectionFigure {
    private RotatableDecoration fDecoratorSource = AccessConnectionFigure.createFigureSourceDecoration();
    private RotatableDecoration fDecoratorTarget = AccessConnectionFigure.createFigureTargetDecoration();

    public static RotatableDecoration createFigureSourceDecoration() {
        return new PolylineDecoration();
    }

    public static RotatableDecoration createFigureTargetDecoration() {
        return new PolylineDecoration();
    }

    @Override
    protected void setFigureProperties() {
        this.setLineStyle(6);
        this.setLineDash(this.getLineDashFloats());
    }

    @Override
    protected float[] getLineDashFloats() {
        double scale = Math.min(FigureUtils.getFigureScale(this), 1.0);
        return new float[]{(float)(2.0 * scale)};
    }

    @Override
    public void refreshVisuals() {
        boolean usePlainArrowHeadOnJunction = this.usePlainJunctionTargetDecoration();
        IAccessRelationship relation = (IAccessRelationship)this.getDiagramModelArchimateConnection().getArchimateRelationship();
        switch (relation.getAccessType()) {
            default: {
                this.setSourceDecoration(null);
                this.setTargetDecoration(usePlainArrowHeadOnJunction ? null : this.fDecoratorTarget);
                break;
            }
            case 1: {
                this.setSourceDecoration(this.fDecoratorSource);
                this.setTargetDecoration(null);
                break;
            }
            case 2: {
                this.setSourceDecoration(null);
                this.setTargetDecoration(null);
                break;
            }
            case 3: {
                this.setSourceDecoration(this.fDecoratorSource);
                this.setTargetDecoration(usePlainArrowHeadOnJunction ? null : this.fDecoratorTarget);
            }
        }
        super.refreshVisuals();
    }

    @Override
    public IFigure getToolTip() {
        ToolTipFigure tooltip = (ToolTipFigure)super.getToolTip();
        if (tooltip == null) {
            return null;
        }
        IAccessRelationship relation = (IAccessRelationship)this.getDiagramModelArchimateConnection().getArchimateRelationship();
        Object type = ArchiLabelProvider.INSTANCE.getDefaultName(relation.eClass());
        switch (relation.getAccessType()) {
            case 0: {
                type = (String)type + " " + Messages.AccessConnectionFigure_0;
                break;
            }
            case 1: {
                type = (String)type + " " + Messages.AccessConnectionFigure_1;
                break;
            }
            case 2: {
                type = (String)type + " " + Messages.AccessConnectionFigure_2;
                break;
            }
            case 3: {
                type = (String)type + " " + Messages.AccessConnectionFigure_3;
                break;
            }
        }
        tooltip.setType(Messages.AccessConnectionFigure_4 + " " + (String)type);
        return tooltip;
    }
}

