/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.diagram;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.model.IDiagramModelImage;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DiagramImageFigure
extends AbstractDiagramModelObjectFigure {
    private Image fImage;
    private Dimension fOriginalImageSize;
    private Dimension fCurrentImageSize;
    private Color fBorderColor;
    boolean useScaledImage = ArchiPlugin.getInstance().getPreferenceStore().getBoolean("scaledImages");

    public DiagramImageFigure(IDiagramModelImage diagramModelImage) {
        super((IDiagramModelObject)diagramModelImage);
    }

    public IDiagramModelImage getDiagramModelObject() {
        return (IDiagramModelImage)super.getDiagramModelObject();
    }

    @Override
    protected void setUI() {
        this.setLayoutManager((LayoutManager)new GridLayout());
        this.setOpaque(true);
        this.setImage();
    }

    public void updateImage() {
        this.setImage();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void refreshVisuals() {
        this.setBorderColor();
        this.repaint();
    }

    protected void setBorderColor() {
        String val = this.getDiagramModelObject().getBorderColor();
        this.fBorderColor = ColorFactory.get(val);
    }

    public Color getBorderColor() {
        return this.fBorderColor;
    }

    @Override
    public Dimension getDefaultSize() {
        return this.fOriginalImageSize == null ? super.getDefaultSize() : this.fOriginalImageSize;
    }

    protected void paintFigure(Graphics graphics) {
        boolean drawBorder;
        graphics.pushState();
        graphics.setAntialias(1);
        graphics.setInterpolation(2);
        graphics.setAlpha(this.getDiagramModelObject().getAlpha());
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        boolean bl = drawBorder = this.getBorderColor() != null && this.getLineStyle() != 3;
        if (drawBorder) {
            this.setLineWidth(graphics, bounds);
            this.setLineStyle(graphics);
        }
        if (this.fImage != null) {
            if (this.useScaledImage) {
                this.rescaleImage();
                graphics.pushState();
                graphics.clipRect(bounds);
                graphics.drawImage(this.fImage, bounds.x, bounds.y);
                graphics.popState();
            } else {
                graphics.drawImage(this.fImage, 0, 0, this.fImage.getBounds().width, this.fImage.getBounds().height, bounds.x, bounds.y, bounds.width, bounds.height);
            }
        } else {
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.fillRectangle(bounds);
            Image image = IArchiImages.ImageFactory.getImage("img/landscape.png");
            graphics.drawImage(image, bounds.x + bounds.width / 2 - 7, bounds.y + bounds.height / 2 - 7);
        }
        if (drawBorder) {
            graphics.setAlpha(this.getDiagramModelObject().getLineAlpha());
            graphics.setForegroundColor(this.getBorderColor());
            graphics.drawRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        graphics.popState();
    }

    protected void setImage() {
        this.disposeImage();
        this.fImage = this.getOriginalImage();
        if (this.fImage != null) {
            this.fOriginalImageSize = new Dimension(this.fImage);
            this.fCurrentImageSize = new Dimension(this.fOriginalImageSize);
        } else {
            this.fOriginalImageSize = null;
        }
    }

    protected Image getOriginalImage() {
        Image image = null;
        String imagePath = this.getDiagramModelObject().getImagePath();
        if (imagePath != null) {
            IArchiveManager archiveManager = (IArchiveManager)this.getDiagramModelObject().getAdapter(IArchiveManager.class);
            try {
                image = archiveManager.createImage(imagePath);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return image;
    }

    protected void rescaleImage() {
        int width = this.bounds.width;
        int height = this.bounds.height;
        if (width <= 0 && height <= 0) {
            return;
        }
        if (width != this.fCurrentImageSize.width || height != this.fCurrentImageSize.height) {
            this.disposeImage();
            Image originalImage = this.getOriginalImage();
            if (width == originalImage.getBounds().width && height == originalImage.getBounds().height) {
                this.fImage = originalImage;
            } else {
                this.fImage = ImageFactory.getScaledImage(originalImage, width, height);
                originalImage.dispose();
            }
            this.fCurrentImageSize = new Dimension(this.fImage);
        }
    }

    protected void disposeImage() {
        if (this.fImage != null && !this.fImage.isDisposed()) {
            this.fImage.dispose();
            this.fImage = null;
        }
    }

    @Override
    public IFigure getTextControl() {
        return null;
    }

    @Override
    public void dispose() {
        this.disposeImage();
        this.fBorderColor = null;
    }
}

