/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.diagram;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.ToolTipFigure;
import com.archimatetool.editor.diagram.figures.diagram.Messages;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.model.IDiagramModelGroup;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class GroupFigure
extends AbstractTextControlContainerFigure {
    private static final int TOPBAR_HEIGHT = 18;
    private static final float INSET = 2.0f;
    private int tabHeight;
    private int tabWidth;

    public GroupFigure(IDiagramModelObject diagramModelObject) {
        super(diagramModelObject, 0);
    }

    public IDiagramModelGroup getDiagramModelObject() {
        return (IDiagramModelGroup)super.getDiagramModelObject();
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        boolean drawOutline;
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        boolean bl = drawOutline = this.getLineStyle() != 3;
        if (drawOutline) {
            this.setLineWidth(graphics, bounds);
            this.setLineStyle(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        if (this.getDiagramModelObject().getBorderType() == 0) {
            this.tabWidth = (int)((float)bounds.width / 2.0f);
            this.tabHeight = 18;
            if (this.getDiagramModelObject().getTextPosition() == 0) {
                int textWidth = FigureUtilities.getTextExtents((String)this.getText(), (Font)this.getFont()).width;
                this.tabWidth = Math.min(Math.max(this.tabWidth, textWidth + 8), bounds.width);
                int textHeight = FigureUtilities.getFontMetrics((Font)this.getFont()).getHeight();
                this.tabHeight = Math.max(18, textHeight);
            }
            graphics.setBackgroundColor(ColorFactory.getDarkerColor(this.getFillColor()));
            Path path1 = new Path(null);
            path1.moveTo((float)bounds.x, (float)bounds.y);
            path1.lineTo((float)(bounds.x + this.tabWidth), (float)bounds.y);
            path1.lineTo((float)(bounds.x + this.tabWidth), (float)(bounds.y + this.tabHeight));
            path1.lineTo((float)bounds.x, (float)(bounds.y + this.tabHeight));
            path1.lineTo((float)bounds.x, (float)bounds.y);
            graphics.fillPath(path1);
            path1.dispose();
            graphics.setBackgroundColor(this.getFillColor());
            Pattern gradient = this.applyGradientPattern(graphics, bounds);
            Path path2 = new Path(null);
            path2.moveTo((float)bounds.x, (float)(bounds.y + this.tabHeight));
            path2.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + this.tabHeight));
            path2.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height));
            path2.lineTo((float)bounds.x, (float)(bounds.y + bounds.height));
            graphics.fillPath(path2);
            path2.dispose();
            this.disposeGradientPattern(graphics, gradient);
            if (this.getIconicDelegate() != null) {
                this.getIconicDelegate().setTopOffset(this.tabHeight);
                this.drawIconImage(graphics, bounds);
            }
            if (drawOutline) {
                graphics.setForegroundColor(this.getLineColor());
                graphics.setAlpha(this.getLineAlpha());
                Path path = new Path(null);
                path.moveTo((float)bounds.x, (float)(bounds.y + this.tabHeight));
                path.lineTo((float)bounds.x, (float)bounds.y);
                path.lineTo((float)(bounds.x + this.tabWidth), (float)bounds.y);
                path.lineTo((float)(bounds.x + this.tabWidth), (float)(bounds.y + this.tabHeight));
                graphics.drawPath(path);
                path.dispose();
                graphics.drawRectangle(bounds.x, bounds.y + this.tabHeight, bounds.width, bounds.height - this.tabHeight);
            }
        } else {
            graphics.setBackgroundColor(this.getFillColor());
            Pattern gradient = this.applyGradientPattern(graphics, bounds);
            graphics.fillRectangle(bounds);
            this.disposeGradientPattern(graphics, gradient);
            if (this.getIconicDelegate() != null) {
                this.getIconicDelegate().setTopOffset(0);
                this.drawIconImage(graphics, bounds);
            }
            if (drawOutline) {
                graphics.setForegroundColor(this.getLineColor());
                graphics.setAlpha(this.getLineAlpha());
                graphics.drawRectangle(bounds);
            }
        }
        graphics.popState();
    }

    @Override
    protected Rectangle calculateTextControlBounds() {
        Rectangle bounds = this.getBounds().getCopy();
        int textPosition = this.getDiagramModelObject().getTextPosition();
        if (textPosition == 0) {
            bounds.y += 5 - this.getTextControlMarginHeight();
            bounds.y -= Math.max(3, FigureUtilities.getFontMetrics((Font)this.getFont()).getLeading());
        }
        return bounds;
    }

    @Override
    public IFigure getToolTip() {
        ToolTipFigure tooltip = (ToolTipFigure)super.getToolTip();
        if (tooltip == null) {
            return null;
        }
        tooltip.setText(Messages.GroupFigure_0);
        return tooltip;
    }

    @Override
    public ConnectionAnchor getDefaultConnectionAnchor() {
        return new GroupFigureConnectionAnchor(this);
    }

    private class GroupFigureConnectionAnchor
    extends ChopboxAnchor {
        public GroupFigureConnectionAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point pt = super.getLocation(reference);
            if (GroupFigure.this.getDiagramModelObject().getBorderType() == 1) {
                return pt;
            }
            Rectangle r = this.getBox().getCopy();
            this.getOwner().translateToAbsolute((Translatable)r);
            int shiftY = GroupFigure.this.tabHeight - (pt.y - r.y) - 1;
            if ((float)pt.x > (float)r.x + (float)r.width / 2.0f && shiftY > 0) {
                pt.y += shiftY;
            }
            return pt;
        }
    }
}

