/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.diagram;

import com.archimatetool.editor.diagram.figures.FigureUtils;
import com.archimatetool.editor.diagram.figures.ToolTipFigure;
import com.archimatetool.editor.diagram.figures.connections.AbstractDiagramConnectionFigure;
import com.archimatetool.editor.diagram.figures.diagram.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;

public class LineConnectionFigure
extends AbstractDiagramConnectionFigure {
    private PolygonDecoration fArrowheadSourceFilled;
    private PolylineDecoration fArrowheadSourceLine;
    private PolygonDecoration fArrowheadSourceHollow;
    private PolygonDecoration fArrowheadTargetFilled;
    private PolylineDecoration fArrowheadTargetLine;
    private PolygonDecoration fArrowheadTargetHollow;

    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        int connectionType = this.getModelConnection().getType();
        if ((connectionType & 8) != 0) {
            this.setSourceDecoration((RotatableDecoration)this.getArrowheadSourceFilled());
        } else if ((connectionType & 0x80) != 0) {
            this.setSourceDecoration((RotatableDecoration)this.getArrowheadSourceLine());
        } else if ((connectionType & 0x20) != 0) {
            this.setSourceDecoration((RotatableDecoration)this.getArrowheadSourceHollow());
        } else {
            this.setSourceDecoration(null);
        }
        if ((connectionType & 1) != 0) {
            this.setTargetDecoration((RotatableDecoration)this.getArrowheadTargetFilled());
        } else if ((connectionType & 0x40) != 0) {
            this.setTargetDecoration((RotatableDecoration)this.getArrowheadTargetLine());
        } else if ((connectionType & 0x10) != 0) {
            this.setTargetDecoration((RotatableDecoration)this.getArrowheadTargetHollow());
        } else {
            this.setTargetDecoration(null);
        }
        if ((connectionType & 2) != 0) {
            this.setLineStyle(6);
            this.setLineDash(this.getLineDashFloats());
        } else if ((connectionType & 4) != 0) {
            this.setLineStyle(6);
            this.setLineDash(this.getLineDashFloats());
        } else {
            this.setLineStyle(1);
        }
        this.repaint();
    }

    @Override
    protected float[] getLineDashFloats() {
        double scale = Math.min(FigureUtils.getFigureScale(this), 1.0);
        int connectionType = this.getModelConnection().getType();
        if ((connectionType & 2) != 0) {
            return new float[]{(float)(4.0 * scale)};
        }
        if ((connectionType & 4) != 0) {
            return new float[]{(float)(1.0 * scale), (float)(4.0 * scale)};
        }
        return null;
    }

    protected PolygonDecoration getArrowheadSourceFilled() {
        if (this.fArrowheadSourceFilled == null) {
            this.fArrowheadSourceFilled = this.createArrowheadFilled();
        }
        return this.fArrowheadSourceFilled;
    }

    protected PolylineDecoration getArrowheadSourceLine() {
        if (this.fArrowheadSourceLine == null) {
            this.fArrowheadSourceLine = this.createArrowheadLine();
        }
        return this.fArrowheadSourceLine;
    }

    protected PolygonDecoration getArrowheadSourceHollow() {
        if (this.fArrowheadSourceHollow == null) {
            this.fArrowheadSourceHollow = this.createArrowheadHollow();
        }
        return this.fArrowheadSourceHollow;
    }

    protected PolygonDecoration getArrowheadTargetFilled() {
        if (this.fArrowheadTargetFilled == null) {
            this.fArrowheadTargetFilled = this.createArrowheadFilled();
        }
        return this.fArrowheadTargetFilled;
    }

    protected PolylineDecoration getArrowheadTargetLine() {
        if (this.fArrowheadTargetLine == null) {
            this.fArrowheadTargetLine = this.createArrowheadLine();
        }
        return this.fArrowheadTargetLine;
    }

    protected PolygonDecoration getArrowheadTargetHollow() {
        if (this.fArrowheadTargetHollow == null) {
            this.fArrowheadTargetHollow = this.createArrowheadHollow();
        }
        return this.fArrowheadTargetHollow;
    }

    protected PolygonDecoration createArrowheadFilled() {
        PolygonDecoration poly = new PolygonDecoration();
        poly.setScale(10.0, 6.0);
        return poly;
    }

    protected PolygonDecoration createArrowheadHollow() {
        PolygonDecoration poly = new PolygonDecoration();
        poly.setScale(10.0, 7.0);
        poly.setBackgroundColor(ColorConstants.white);
        return poly;
    }

    protected PolylineDecoration createArrowheadLine() {
        PolylineDecoration poly = new PolylineDecoration();
        poly.setScale(8.0, 5.0);
        return poly;
    }

    @Override
    public IFigure getToolTip() {
        ToolTipFigure tooltip = (ToolTipFigure)super.getToolTip();
        if (tooltip == null) {
            return null;
        }
        String text = ArchiLabelProvider.INSTANCE.getLabel(this.getModelConnection());
        tooltip.setText(text);
        tooltip.setType(Messages.LineConnectionFigure_0);
        return tooltip;
    }
}

