/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.FigureUtils;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public abstract class AbstractMotivationFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    protected static final int FLANGE = 10;

    protected AbstractMotivationFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        boolean drawOutline;
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            return;
        }
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        boolean bl = drawOutline = this.getLineStyle() != 3;
        if (drawOutline) {
            this.setLineWidth(graphics, bounds);
            this.setLineStyle(graphics);
        }
        PointList points = new PointList();
        points.addPoint(bounds.x + 10, bounds.y);
        points.addPoint(bounds.x + bounds.width - 10, bounds.y);
        points.addPoint(bounds.x + bounds.width, bounds.y + 10);
        points.addPoint(bounds.x + bounds.width, bounds.y + bounds.height - 10);
        points.addPoint(bounds.x + bounds.width - 10, bounds.y + bounds.height);
        points.addPoint(bounds.x + 10, bounds.y + bounds.height);
        points.addPoint(bounds.x, bounds.y + bounds.height - 10);
        points.addPoint(bounds.x, bounds.y + 10);
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        Path path = FigureUtils.createPathFromPoints(points);
        graphics.fillPath(path);
        path.dispose();
        this.disposeGradientPattern(graphics, gradient);
        if (drawOutline) {
            graphics.setAlpha(this.getLineAlpha());
            graphics.setForegroundColor(this.getLineColor());
            graphics.drawPolygon(points);
        }
        Rectangle imageArea = new Rectangle(bounds.x + 5, bounds.y + 5, bounds.width - 10, bounds.height - 10);
        this.drawIconImage(graphics, bounds, imageArea, 0, 0, 0, 0);
        graphics.popState();
    }
}

