/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.elements.AbstractMotivationFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class AssessmentFigure
extends AbstractMotivationFigure {
    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getDiagramModelArchimateObject().getType() == 0) {
            super.drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        int radius = this.getRadius(rect);
        Point center = this.getCenter(rect);
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        path.addArc((float)center.preciseX() - (float)radius, (float)center.preciseY() - (float)radius, (float)(radius * 2), (float)(radius * 2), 0.0f, 360.0f);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        double ratio = 2.5;
        int x1 = (int)((double)center.x - (double)radius * ratio);
        int y1 = (int)((double)center.y + (double)radius * ratio);
        PrecisionPoint intersection = this.getCircleIntersection(x1, y1, center.preciseX(), center.preciseY(), center.preciseX(), center.preciseY(), radius);
        if (intersection != null) {
            graphics.setClip(rect);
            graphics.drawLine((int)Math.round(intersection.preciseX()), (int)Math.round(intersection.preciseY() - 1.0), x1, y1);
        }
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private int getRadius(Rectangle rect) {
        int r1 = Math.round((float)rect.height / 2.5f);
        int r2 = Math.round((float)rect.width / 2.5f);
        return Math.min(r1, r2);
    }

    private Point getCenter(Rectangle rect) {
        int radius = this.getRadius(rect);
        int figureWidth = (int)((float)radius * 2.5f);
        int figureHeight = (int)((float)radius * 2.5f);
        return new PrecisionPoint(rect.x + rect.width - radius - (rect.width - figureWidth) / 2, rect.y + radius + (rect.height - figureHeight) / 2);
    }

    private PrecisionPoint getCircleIntersection(double x1, double y1, double x2, double y2, double xCenter, double yCenter, double radius) {
        double baX = x2 - x1;
        double caX = xCenter - x1;
        double baY = y2 - y1;
        double caY = yCenter - y1;
        double bBy2 = baX * caX + baY * caY;
        double a = baX * baX + baY * baY;
        double pBy2 = bBy2 / a;
        double c = caX * caX + caY * caY - radius * radius;
        double q = c / a;
        double disc = pBy2 * pBy2 - q;
        if (disc >= 0.0) {
            double sqrtDisc = Math.sqrt(disc);
            double abScalingFactor1 = -pBy2 + sqrtDisc;
            double xi1 = x1 - baX * abScalingFactor1;
            double yi1 = y1 - baY * abScalingFactor1;
            return new PrecisionPoint(xi1, yi1);
        }
        return null;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawOval(pt.x, pt.y, 8, 8);
        graphics.drawLine(pt.x + 2, pt.y + 7, pt.x - 3, pt.y + 12);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 14 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 21 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }
}

