/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class BusinessActorFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public BusinessActorFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect, 0.6666666666666666);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        int diameter = Math.min(rect.width / 2, rect.height / 3);
        path.addArc((float)(rect.x + rect.width / 2 - diameter / 2), (float)(rect.y + rect.height / 2 - diameter - diameter / 2), (float)diameter, (float)diameter, 0.0f, 360.0f);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.setLineCap(2);
        graphics.drawLine(rect.x + rect.width / 2, rect.y + rect.height / 2 - diameter / 2, rect.x + rect.width / 2, rect.y + rect.height / 2 - diameter / 2 + diameter);
        graphics.drawLine(rect.x + rect.width / 2, rect.y + rect.height / 2 - diameter / 2 + diameter, rect.x + rect.width / 2 - diameter, rect.y + rect.height / 2 - diameter / 2 + diameter + diameter);
        graphics.drawLine(rect.x + rect.width / 2, rect.y + rect.height / 2 - diameter / 2 + diameter, rect.x + rect.width / 2 + diameter, rect.y + rect.height / 2 - diameter / 2 + diameter + diameter);
        graphics.drawLine(rect.x + rect.width / 2 - diameter, rect.y + rect.height / 2 - diameter / 4, rect.x + rect.width / 2 + diameter, rect.y + rect.height / 2 - diameter / 4);
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawOval(pt.x, pt.y, 6, 6);
        pt.translate(3, 6);
        graphics.drawLine(pt.x, pt.y, pt.x, pt.y + 6);
        pt.translate(0, 6);
        graphics.drawLine(pt.x, pt.y, pt.x - 4, pt.y + 5);
        graphics.drawLine(pt.x, pt.y, pt.x + 4, pt.y + 5);
        pt.translate(-4, -3);
        graphics.drawLine(pt.x, pt.y, pt.x + 8, pt.y);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds().getCopy();
        return new Point(bounds.x + bounds.width - 10 - this.getLineWidth(), bounds.y + 4);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 17 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

