/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;

public class CommunicationNetworkFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public CommunicationNetworkFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        Rectangle imageBounds = rect.getCopy();
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.setBackgroundColor(this.getLineColor());
        int figureMaxSize = Math.min(rect.width, rect.height);
        float blobDiameter = (int)Math.max(10.0, Math.sqrt(rect.width * rect.height) / 7.0);
        float blobRadius = blobDiameter / 2.0f;
        int lineWidth = (int)blobDiameter / 4;
        graphics.setLineWidth(lineWidth);
        float heightOffset = figureMaxSize / 4;
        float widthOffset = figureMaxSize / 3;
        Point center = rect.getCenter();
        float x = (float)center.x - widthOffset;
        float y = (float)center.y - heightOffset;
        float w = widthOffset * 2.0f;
        float h = heightOffset * 2.0f;
        float indent = w / 5.0f;
        Path path = new Path(null);
        path.addArc(x, y + h - blobDiameter, blobDiameter, blobDiameter, 0.0f, 360.0f);
        path.addArc(x + w - indent - blobDiameter, y + h - blobDiameter, blobDiameter, blobDiameter, 0.0f, 360.0f);
        path.addArc(x + indent, y, blobDiameter, blobDiameter, 0.0f, 360.0f);
        path.addArc(x + w - blobDiameter, y, blobDiameter, blobDiameter, 0.0f, 360.0f);
        graphics.fillPath(path);
        path.dispose();
        path = new Path(null);
        float x1 = x + blobRadius;
        float y1 = y + h - blobRadius;
        float x2 = x1 + w - indent - blobDiameter;
        path.moveTo(x1, y1);
        path.lineTo(x2, y1);
        path.lineTo(x + w - blobRadius, y + blobRadius);
        path.lineTo(x + indent + blobRadius, y + blobRadius);
        path.lineTo(x1, y1);
        graphics.drawPath(path);
        path.dispose();
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidthFloat(1.0f);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        path.addArc((float)pt.x, (float)pt.y, 5.0f, 5.0f, 0.0f, 360.0f);
        path.addArc((float)(pt.x + 2), (float)(pt.y - 8), 5.0f, 5.0f, 0.0f, 360.0f);
        path.addArc((float)(pt.x + 10), (float)(pt.y - 8), 5.0f, 5.0f, 0.0f, 360.0f);
        path.addArc((float)(pt.x + 8), (float)pt.y, 5.0f, 5.0f, 0.0f, 360.0f);
        path.moveTo((float)(pt.x + 3), (float)pt.y);
        path.lineTo((float)(pt.x + 4), (float)(pt.y - 3));
        path.moveTo((float)(pt.x + 11), (float)pt.y);
        path.lineTo((float)(pt.x + 12), (float)(pt.y - 3));
        path.moveTo((float)(pt.x + 5), (float)pt.y + 2.5f);
        path.lineTo((float)(pt.x + 8), (float)pt.y + 2.5f);
        path.moveTo((float)(pt.x + 7), (float)pt.y - 5.5f);
        path.lineTo((float)(pt.x + 10), (float)pt.y - 5.5f);
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 18 - this.getLineWidth(), bounds.y + 14);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 22 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

