/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.ObjectFigure;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Pattern;

public class ContractFigure
extends ObjectFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);
    private IFigureDelegate contractDelegate = new ContractFigureDelegate((AbstractDiagramModelObjectFigure)this);

    @Override
    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawRectangle(pt.x, pt.y, 13, 10);
        graphics.drawLine(pt.x, pt.y + 3, pt.x + 13, pt.y + 3);
        graphics.drawLine(pt.x, pt.y + 7, pt.x + 13, pt.y + 7);
        graphics.popState();
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : this.contractDelegate;
    }

    class ContractFigureDelegate
    extends ObjectFigure.ObjectFigureDelegate {
        ContractFigureDelegate(AbstractDiagramModelObjectFigure owner) {
            super(ContractFigure.this, owner);
        }

        @Override
        public void drawFigure(Graphics graphics) {
            graphics.pushState();
            Rectangle bounds = this.getBounds();
            --bounds.width;
            --bounds.height;
            this.setLineWidth(graphics, bounds);
            graphics.setAlpha(this.getAlpha());
            if (!this.isEnabled()) {
                this.setDisabledState(graphics);
            }
            graphics.setBackgroundColor(this.getFillColor());
            Pattern gradient = this.applyGradientPattern(graphics, bounds);
            graphics.fillRectangle(bounds);
            this.disposeGradientPattern(graphics, gradient);
            graphics.setForegroundColor(this.getLineColor());
            graphics.setAlpha(this.getLineAlpha());
            graphics.drawLine(bounds.x, bounds.y + 12, bounds.x + bounds.width, bounds.y + 12);
            graphics.drawLine(bounds.x, bounds.getBottom().y - 12, bounds.getRight().x, bounds.getBottom().y - 12);
            graphics.drawRectangle(bounds);
            this.getOwner().drawIconImage(graphics, bounds, 12, 0, -12, 0);
            graphics.popState();
        }

        @Override
        public Rectangle calculateTextControlBounds() {
            int textPosition = ((ITextPosition)ContractFigure.this.getDiagramModelObject()).getTextPosition();
            if (textPosition == 2) {
                Rectangle bounds = this.getBounds();
                bounds.y -= 12 - ContractFigure.this.getTextControlMarginHeight();
                return bounds;
            }
            return super.calculateTextControlBounds();
        }
    }
}

