/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class DistributionNetworkFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private static final double ARROW_ANGLE = Math.cos(Math.toRadians(60.0));
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public DistributionNetworkFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        this.setFigurePositionFromTextPosition(rect, 1.6666666666666667);
        int lineWidth = (int)Math.max(3.0, Math.sqrt(rect.width * rect.height) / 24.0);
        Dimension arrowSize = this.getArrowSize(rect);
        rect.shrink(lineWidth, lineWidth);
        arrowSize = this.getArrowSize(rect);
        this.fillSection(graphics, rect, arrowSize);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.setLineWidth(lineWidth);
        this.drawArrows(graphics, rect, arrowSize);
        this.drawHorizontalLine(graphics, rect, arrowSize);
        this.drawIconImage(graphics, rect, 0, 0, 0, 0);
        graphics.popState();
    }

    protected void fillSection(Graphics graphics, Rectangle rect, Dimension arrow) {
        graphics.setBackgroundColor(this.getFillColor());
        graphics.setAlpha(this.getAlpha());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        Rectangle line1 = this.getLine1(rect, arrow);
        Rectangle line2 = this.getLine2(rect, arrow);
        path.moveTo((float)line1.x, (float)line1.y);
        path.lineTo((float)line1.width, (float)line1.height);
        path.lineTo((float)(rect.x + rect.width), (float)(rect.y + rect.height / 2));
        path.lineTo((float)line1.width, (float)line2.y);
        path.lineTo((float)line2.x, (float)line2.y);
        path.lineTo((float)rect.x, (float)(rect.y + rect.height / 2));
        path.close();
        graphics.fillPath(path);
        path.dispose();
        this.disposeGradientPattern(graphics, gradient);
    }

    private Dimension getArrowSize(Rectangle rect) {
        int width = (int)((double)rect.width / (1.0 + ARROW_ANGLE) / 2.0);
        int size = Math.min(rect.height, width);
        return new Dimension((int)((double)size * ARROW_ANGLE), size);
    }

    private void drawArrows(Graphics graphics, Rectangle rect, Dimension arrow) {
        graphics.setLineCap(2);
        graphics.drawLine(rect.x + arrow.width, rect.y + rect.height / 2 - arrow.height / 2, rect.x, rect.y + rect.height / 2);
        graphics.drawLine(rect.x, rect.y + rect.height / 2, rect.x + arrow.width, rect.y + rect.height / 2 + arrow.height / 2);
        graphics.drawLine(rect.x + rect.width - arrow.width, rect.y + rect.height / 2 - arrow.height / 2, rect.x + rect.width, rect.y + rect.height / 2);
        graphics.drawLine(rect.x + rect.width, rect.y + rect.height / 2, rect.x + rect.width - arrow.width, rect.y + rect.height / 2 + arrow.height / 2);
    }

    private Rectangle getLine1(Rectangle rect, Dimension arrow) {
        return new Rectangle(rect.x + arrow.height / 5, rect.y + rect.height / 2 - arrow.height / 5, rect.x + rect.width - arrow.height / 5, rect.y + rect.height / 2 - arrow.height / 5);
    }

    private Rectangle getLine2(Rectangle rect, Dimension arrow) {
        return new Rectangle(rect.x + arrow.height / 5, rect.y + rect.height / 2 + arrow.height / 5, rect.x + rect.width - arrow.height / 5, rect.y + rect.height / 2 + arrow.height / 5);
    }

    protected void drawHorizontalLine(Graphics graphics, Rectangle rect, Dimension arrow) {
        graphics.setLineCap(2);
        Rectangle line1 = this.getLine1(rect, arrow);
        graphics.drawLine(line1.x, line1.y, line1.width, line1.height);
        Rectangle line2 = this.getLine2(rect, arrow);
        graphics.drawLine(line2.x, line2.y, line2.width, line2.height);
    }

    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setForegroundColor(this.getIconColor());
        graphics.setLineWidthFloat(1.5f);
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        path.moveTo((float)(pt.x + 1), (float)(pt.y - 2));
        path.lineTo((float)(pt.x + 14), (float)(pt.y - 2));
        path.moveTo((float)(pt.x + 1), (float)(pt.y + 2));
        path.lineTo((float)(pt.x + 14), (float)(pt.y + 2));
        graphics.drawPath(path);
        path.dispose();
        path = new Path(null);
        path.moveTo((float)(pt.x + 4), (float)(pt.y - 5));
        path.lineTo((float)(pt.x - 1), (float)pt.y);
        path.lineTo((float)(pt.x + 4), (float)(pt.y + 5));
        path.moveTo((float)(pt.x + 11), (float)(pt.y - 5));
        path.lineTo((float)(pt.x + 16), (float)pt.y);
        path.lineTo((float)(pt.x + 11), (float)(pt.y + 5));
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 19 - this.getLineWidth(), bounds.y + 12);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 22 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

