/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.PolarPoint;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class EquipmentFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate figureDelegate = new RectangleFigureDelegate(this);

    public EquipmentFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        int xCenter = rect.x + rect.width / 2;
        int yCenter = rect.y + rect.height / 2;
        int width1 = Math.min(rect.width, rect.height) * 2 / 3;
        Rectangle rect1 = new Rectangle(xCenter - width1 * 2 / 3, yCenter - width1 / 2 + width1 / 4, width1, width1);
        Path path1 = this.getPathShape(rect1);
        graphics.fillPath(path1);
        int width2 = Math.min(rect.width, rect.height) * 1 / 2;
        Rectangle rect2 = new Rectangle(xCenter, (int)((float)yCenter - (float)width2 * 0.96f), width2, width2);
        Path path2 = this.getPathShape(rect2);
        graphics.fillPath(path2);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path1);
        graphics.drawPath(path2);
        path1.dispose();
        path2.dispose();
        this.drawCircle(graphics, rect1);
        this.drawCircle(graphics, rect2);
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawCircle(Graphics graphics, Rectangle rect) {
        graphics.drawOval(rect.getCenter().x - rect.width / 2 + rect.width / 3, rect.getCenter().y - rect.height / 2 + rect.width / 3, rect.width / 3, rect.width / 3);
    }

    private Path getPathShape(Rectangle rect) {
        Path path = new Path(null);
        int figureWidth = rect.width;
        int figureHeight = rect.height;
        if (rect.width > rect.height) {
            figureWidth = rect.height;
            figureHeight = rect.height;
        } else {
            figureWidth = rect.width;
            figureHeight = rect.width;
        }
        PrecisionPoint center = new PrecisionPoint();
        center.setPreciseLocation((double)(rect.x + figureWidth / 2), (double)(rect.y + figureHeight / 2));
        int alphaFirstCircle = 14;
        int betaFirstCircle = 31;
        int alphaSecondCircle = 22;
        int betaSecondCirlce = 23;
        int xMargin = (rect.width - figureWidth) / 2;
        int yMargin = (rect.height - figureHeight) / 2;
        PrecisionPoint firstPoint = new PrecisionPoint();
        firstPoint.setPreciseLocation((double)(rect.x + figureWidth / 2), (double)rect.y);
        PrecisionPoint secondPoint = new PrecisionPoint();
        secondPoint.setPreciseLocation((double)(rect.x + figureWidth / 2) - (double)figureWidth / 5.9, (double)rect.y + (double)figureHeight / 6.5);
        PrecisionPoint firstCirclePoint = new PrecisionPoint();
        firstCirclePoint = this.rotatePoint(firstPoint, center, alphaFirstCircle);
        PrecisionPoint secondCirclePoint = new PrecisionPoint();
        secondCirclePoint = this.rotatePoint(secondPoint, center, alphaSecondCircle);
        secondCirclePoint = this.rotatePoint(secondCirclePoint, center, betaSecondCirlce);
        path.moveTo((float)firstPoint.preciseX() + (float)xMargin, (float)firstPoint.preciseY() + (float)yMargin);
        path.lineTo((float)firstCirclePoint.preciseX() + (float)xMargin, (float)firstCirclePoint.preciseY() + (float)yMargin);
        path.lineTo((float)secondCirclePoint.preciseX() + (float)xMargin, (float)secondCirclePoint.preciseY() + (float)yMargin);
        secondCirclePoint = this.rotatePoint(secondCirclePoint, center, alphaSecondCircle);
        path.lineTo((float)secondCirclePoint.preciseX() + (float)xMargin, (float)secondCirclePoint.preciseY() + (float)yMargin);
        int i = 0;
        while (i < 7) {
            firstCirclePoint = this.rotatePoint(firstCirclePoint, center, betaFirstCircle);
            path.lineTo((float)firstCirclePoint.preciseX() + (float)xMargin, (float)firstCirclePoint.preciseY() + (float)yMargin);
            firstCirclePoint = this.rotatePoint(firstCirclePoint, center, alphaFirstCircle);
            path.lineTo((float)firstCirclePoint.preciseX() + (float)xMargin, (float)firstCirclePoint.preciseY() + (float)yMargin);
            secondCirclePoint = this.rotatePoint(secondCirclePoint, center, betaSecondCirlce);
            path.lineTo((float)secondCirclePoint.preciseX() + (float)xMargin, (float)secondCirclePoint.preciseY() + (float)yMargin);
            secondCirclePoint = this.rotatePoint(secondCirclePoint, center, alphaSecondCircle);
            path.lineTo((float)secondCirclePoint.preciseX() + (float)xMargin, (float)secondCirclePoint.preciseY() + (float)yMargin);
            ++i;
        }
        path.close();
        return path;
    }

    private PrecisionPoint rotatePoint(PrecisionPoint point, PrecisionPoint rotationCenter, double degreeAngle) {
        double radAngle = degreeAngle * Math.PI / 180.0;
        double xM = point.preciseX() - rotationCenter.preciseX();
        double yM = point.preciseY() - rotationCenter.preciseY();
        PrecisionPoint newPoint = new PrecisionPoint();
        newPoint.setPreciseLocation(xM * Math.cos(radAngle) - yM * Math.sin(radAngle) + rotationCenter.preciseX(), xM * Math.sin(radAngle) + yM * Math.cos(radAngle) + rotationCenter.preciseY());
        return newPoint;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        this.drawIconCog(graphics, pt.getTranslated(5, 3), 8, 3, 6, 8);
        this.drawIconCog(graphics, pt.getTranslated(10, -8), 6, 2, 4, 5);
        graphics.popState();
    }

    private void drawIconCog(Graphics graphics, Point center, int segments, int r1, int r2, int r3) {
        PointList outer = new PointList();
        double halfSeg = Math.PI / (double)(2 * segments);
        double delta = halfSeg / 4.0;
        int i = 0;
        while (i < segments) {
            outer.addPoint(new PolarPoint(r2, Math.PI * 2 * (double)i / (double)segments - halfSeg).toAbsolutePoint(center));
            outer.addPoint(new PolarPoint(r3, Math.PI * 2 * (double)i / (double)segments - halfSeg + delta).toAbsolutePoint(center));
            outer.addPoint(new PolarPoint(r3, Math.PI * 2 * (double)i / (double)segments + halfSeg - delta).toAbsolutePoint(center));
            outer.addPoint(new PolarPoint(r2, Math.PI * 2 * (double)i / (double)segments + halfSeg).toAbsolutePoint(center));
            ++i;
        }
        graphics.drawPolygon(outer);
        Path path = new Path(null);
        path.addArc((float)(center.x - r1), (float)(center.y - r1), (float)(2 * r1), (float)(2 * r1), 0.0f, 360.0f);
        graphics.drawPath(path);
        path.dispose();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 18 - this.getLineWidth(), bounds.y + 17);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 22 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.figureDelegate : null;
    }
}

