/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RoundedRectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class EventFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    protected IFigureDelegate fMainFigureDelegate = new RoundedRectangleFigureDelegate(this);

    public EventFigure() {
        super(0);
    }

    @Override
    public void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        int indent = Math.min(bounds.height / 3, bounds.width / 3);
        int centre_y = bounds.y + bounds.height / 2 - 1;
        int arc_startx = bounds.x + bounds.width - indent;
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        Path path = new Path(null);
        path.moveTo((float)bounds.x, (float)bounds.y);
        path.lineTo((float)(bounds.x + indent), (float)centre_y);
        path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height));
        path.lineTo((float)arc_startx, (float)(bounds.y + bounds.height));
        path.addArc((float)(arc_startx - indent), (float)bounds.y, (float)(indent * 2), (float)bounds.height, -90.0f, 180.0f);
        path.lineTo((float)bounds.x, (float)bounds.y);
        path.lineTo((float)(bounds.x + indent), (float)centre_y);
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        this.drawIconImage(graphics, bounds);
        graphics.popState();
    }

    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        path.moveTo((float)pt.x, (float)pt.y);
        path.addArc((float)(pt.x - 4), (float)pt.y, 8.0f, 9.0f, 270.0f, 180.0f);
        graphics.drawPath(path);
        path.dispose();
        path = new Path(null);
        path.moveTo((float)pt.x, (float)pt.y);
        path.addArc((float)(pt.x + 8), (float)pt.y, 8.0f, 9.0f, 270.0f, 180.0f);
        path.moveTo((float)pt.x, (float)pt.y);
        path.lineTo((float)(pt.x + 12), (float)pt.y);
        path.moveTo((float)pt.x, (float)(pt.y + 9));
        path.lineTo((float)(pt.x + 12), (float)(pt.y + 9));
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    protected Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 19 - this.getLineWidth(), bounds.y + 7);
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.fMainFigureDelegate : null;
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 22 : 0;
    }
}

