/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class FacilityFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate figureDelegate = new RectangleFigureDelegate(this);

    public FacilityFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = this.getFigurePath(rect);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private Path getFigurePath(Rectangle rect) {
        Path path = new Path(null);
        int figureWidth = 0;
        int figureHeight = 0;
        if (rect.width <= rect.height) {
            figureWidth = rect.width;
            figureHeight = rect.width;
        } else {
            figureHeight = rect.height;
            figureWidth = rect.height;
        }
        int xMargin = (rect.width - figureWidth) / 2;
        int yMargin = (rect.height - figureHeight) / 2;
        int xTooth = figureWidth / 4 + figureWidth / 20;
        int yTooth = figureHeight / 5;
        path.moveTo((float)(rect.x + xMargin), (float)(rect.y + yMargin));
        path.lineTo((float)(rect.x + xMargin), (float)(rect.y + yMargin + figureHeight));
        path.lineTo((float)(rect.x + xMargin + figureWidth), (float)(rect.y + yMargin + figureHeight));
        path.lineTo((float)(rect.x + xMargin + figureWidth), (float)(rect.y + yMargin) + (float)figureHeight / 2.0f);
        path.lineTo((float)(rect.x + xMargin + figureWidth - xTooth), (float)(rect.y + yMargin) + (float)figureHeight / 2.0f + (float)yTooth);
        path.lineTo((float)(rect.x + xMargin + figureWidth - xTooth), (float)(rect.y + yMargin) + (float)figureHeight / 2.0f);
        path.lineTo((float)(rect.x + xMargin + figureWidth - 2 * xTooth), (float)(rect.y + yMargin) + (float)figureHeight / 2.0f + (float)yTooth);
        path.lineTo((float)(rect.x + xMargin + figureWidth - 2 * xTooth), (float)(rect.y + yMargin) + (float)figureHeight / 2.0f);
        path.lineTo((float)(rect.x + xMargin + figureWidth - 3 * xTooth), (float)(rect.y + yMargin) + (float)figureHeight / 2.0f + (float)yTooth);
        path.lineTo((float)(rect.x + xMargin + figureWidth - 3 * xTooth), (float)(rect.y + yMargin));
        path.close();
        return path;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setForegroundColor(this.getIconColor());
        graphics.setLineWidthFloat(1.2f);
        Point pt = this.getIconOrigin();
        graphics.drawPolygon(new int[]{pt.x, pt.y, pt.x + 15, pt.y, pt.x + 15, pt.y - 6, pt.x + 11, pt.y - 3, pt.x + 11, pt.y - 6, pt.x + 7, pt.y - 3, pt.x + 7, pt.y - 6, pt.x + 3, pt.y - 3, pt.x + 3, pt.y - 12, pt.x, pt.y - 12});
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.getRight().x - 19 - this.getLineWidth(), bounds.y + 17);
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.figureDelegate : null;
    }
}

