/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.FigureUtils;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class GroupingFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private static final int TOPBAR_HEIGHT = 18;
    private static final float INSET = 1.4f;
    private int tabHeight;
    private int tabWidth;

    public GroupingFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        int[] mainRectangle;
        boolean drawOutline;
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        graphics.setAntialias(1);
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        boolean bl = drawOutline = this.getLineStyle() != 3;
        if (drawOutline) {
            this.setLineWidth(graphics, bounds);
            this.setLineStyle(graphics);
        }
        graphics.setBackgroundColor(this.getFillColor());
        graphics.setForegroundColor(this.getLineColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        if (this.getDiagramModelArchimateObject().getType() == 0) {
            mainRectangle = new int[]{bounds.x, bounds.y, bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, bounds.x, bounds.y + bounds.height};
            Path path = FigureUtils.createPathFromPoints(mainRectangle);
            graphics.fillPath(path);
            path.dispose();
            if (this.getIconicDelegate() != null) {
                this.getIconicDelegate().setTopOffset(0);
                this.drawIconImage(graphics, bounds);
            }
        } else {
            this.tabWidth = (int)((float)bounds.width / 1.4f);
            this.tabHeight = 18;
            if (this.getDiagramModelArchimateObject().getTextPosition() == 0) {
                int textWidth = FigureUtilities.getTextExtents((String)this.getText(), (Font)this.getFont()).width;
                this.tabWidth = Math.min(Math.max(this.tabWidth, textWidth + 8), bounds.width);
                int textHeight = FigureUtilities.getFontMetrics((Font)this.getFont()).getHeight();
                this.tabHeight = Math.max(18, textHeight);
            }
            mainRectangle = new int[]{bounds.x, bounds.y + this.tabHeight, bounds.x + bounds.width, bounds.y + this.tabHeight, bounds.x + bounds.width, bounds.y + bounds.height, bounds.x, bounds.y + bounds.height};
            int[] fillShape = new int[]{bounds.x, bounds.y, bounds.x + this.tabWidth, bounds.y, bounds.x + this.tabWidth, bounds.y + this.tabHeight, bounds.getRight().x, bounds.y + this.tabHeight, bounds.getRight().x, bounds.getBottom().y, bounds.x, bounds.getBottom().y};
            Path path = FigureUtils.createPathFromPoints(fillShape);
            graphics.fillPath(path);
            path.dispose();
            if (this.getIconicDelegate() != null) {
                this.getIconicDelegate().setTopOffset(this.tabHeight);
                this.drawIconImage(graphics, bounds);
            }
            if (drawOutline) {
                graphics.setAlpha(this.getLineAlpha());
                graphics.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + this.tabHeight);
                graphics.drawLine(bounds.x, bounds.y, bounds.x + this.tabWidth, bounds.y);
                graphics.drawLine(bounds.x + this.tabWidth, bounds.y, bounds.x + this.tabWidth, bounds.y + this.tabHeight);
            }
        }
        this.disposeGradientPattern(graphics, gradient);
        if (drawOutline) {
            graphics.setAlpha(this.getLineAlpha());
            graphics.drawPolygon(mainRectangle);
        }
        graphics.popState();
        if (this.getDiagramModelArchimateObject().getType() == 0) {
            this.drawIcon(graphics);
        }
    }

    @Override
    protected Rectangle calculateTextControlBounds() {
        Rectangle bounds = this.getBounds().getCopy();
        int textPosition = ((ITextPosition)this.getDiagramModelObject()).getTextPosition();
        int textAlignment = this.getDiagramModelObject().getTextAlignment();
        if (textPosition == 0) {
            bounds.y += 5 - this.getTextControlMarginHeight();
            bounds.y -= Math.max(3, FigureUtilities.getFontMetrics((Font)this.getFont()).getLeading());
            if (this.getIconOffset() != 0 && this.isIconVisible() && textAlignment == 4) {
                int iconOffset = this.getIconOffset() - this.getTextControlMarginWidth();
                bounds.width -= iconOffset;
            }
        }
        return bounds;
    }

    @Override
    public ConnectionAnchor getDefaultConnectionAnchor() {
        return new GroupingFigureConnectionAnchor(this);
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawRectangle(pt.x, pt.y, 6, 3);
        graphics.drawRectangle(pt.x, pt.y + 3, 13, 7);
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 17 - this.getLineWidth(), bounds.y + 6);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 20 : 0;
    }

    private class GroupingFigureConnectionAnchor
    extends ChopboxAnchor {
        public GroupingFigureConnectionAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point pt = super.getLocation(reference);
            if (GroupingFigure.this.getDiagramModelArchimateObject().getType() == 0) {
                return pt;
            }
            Rectangle r = this.getBox().getCopy();
            this.getOwner().translateToAbsolute((Translatable)r);
            int shiftY = GroupingFigure.this.tabHeight - (pt.y - r.y) - 1;
            if ((float)pt.x > (float)r.x + (float)r.width / 1.4f && shiftY > 0) {
                pt.y += shiftY;
            }
            return pt;
        }
    }
}

