/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class LocationFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public LocationFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = this.getFigurePath(rect);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private Path getFigurePath(Rectangle rect) {
        int figureWidth = 0;
        int figureHeight = 0;
        if (rect.width <= rect.height) {
            figureWidth = rect.width;
            figureHeight = rect.width;
        } else {
            figureHeight = rect.height;
            figureWidth = rect.height;
        }
        int yMargin = (rect.height - figureHeight) / 2;
        int xCenter = rect.x + rect.width / 2;
        float diameter = figureWidth / 4 * 3;
        Path path = new Path(null);
        path.addArc((float)xCenter - diameter / 2.0f, (float)(rect.y + yMargin), diameter, diameter, -35.0f, 250.0f);
        path.lineTo((float)xCenter, (float)(rect.y + rect.height - yMargin));
        path.close();
        return path;
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        Path path = new Path(null);
        path.addArc((float)(pt.x - 5), (float)(pt.y - 15), 10.0f, 10.0f, -20.0f, 220.0f);
        path.lineTo((float)pt.x, (float)pt.y);
        path.close();
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 8 - this.getLineWidth(), bounds.y + 20);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 16 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

