/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.diagram.figures.IFigureDelegate;
import com.archimatetool.editor.diagram.figures.RectangleFigureDelegate;
import com.archimatetool.editor.diagram.figures.elements.IArchimateFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class MaterialFigure
extends AbstractTextControlContainerFigure
implements IArchimateFigure {
    private IFigureDelegate rectangleDelegate = new RectangleFigureDelegate(this);

    public MaterialFigure() {
        super(0);
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        --rect.width;
        --rect.height;
        Rectangle imageBounds = rect.getCopy();
        this.setLineWidth(graphics, rect);
        this.setFigurePositionFromTextPosition(rect, 1.1111111111111112);
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, rect);
        Path path = new Path(null);
        int figureWidth = rect.width;
        int figureHeight = rect.height;
        if (rect.width <= rect.height) {
            figureHeight = rect.width - rect.width / 10;
        } else {
            figureWidth = rect.height + rect.width / 10;
            figureWidth = Math.min(figureWidth, rect.width);
        }
        int xMargin = (rect.width - figureWidth) / 2;
        int yMargin = (rect.height - figureHeight) / 2;
        path.moveTo((float)(rect.x + xMargin + figureWidth / 4), (float)(rect.y + yMargin));
        path.lineTo((float)(rect.x + xMargin), (float)(rect.y + yMargin + figureHeight / 2));
        path.lineTo((float)(rect.x + xMargin + figureWidth / 4), (float)(rect.y + yMargin + figureHeight));
        path.lineTo((float)(rect.x + xMargin + 3 * figureWidth / 4), (float)(rect.y + yMargin + figureHeight));
        path.lineTo((float)(rect.x + xMargin + figureWidth), (float)(rect.y + yMargin + figureHeight / 2));
        path.lineTo((float)(rect.x + xMargin + 3 * figureWidth / 4), (float)(rect.y + yMargin));
        path.lineTo((float)(rect.x + xMargin + figureWidth / 4), (float)(rect.y + yMargin));
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        path = new Path(null);
        path.moveTo((float)(rect.x + xMargin + 3 * figureWidth / 8), (float)(rect.y + yMargin + figureHeight / 10));
        path.lineTo((float)(rect.x + xMargin + figureWidth / 6), (float)(rect.y + yMargin + figureHeight / 2));
        path.moveTo((float)(rect.x + xMargin + figureWidth / 3), (float)(rect.y + yMargin + figureHeight - figureHeight / 7));
        path.lineTo((float)(rect.x + xMargin + figureWidth - figureWidth / 3), (float)(rect.y + yMargin + figureHeight - figureHeight / 7));
        path.moveTo((float)(rect.x + xMargin + figureWidth - 3 * figureWidth / 8), (float)(rect.y + yMargin + figureHeight / 10));
        path.lineTo((float)(rect.x + xMargin + figureWidth - figureWidth / 6), (float)(rect.y + yMargin + figureHeight / 2));
        graphics.drawPath(path);
        path.dispose();
        this.drawIconImage(graphics, imageBounds, 0, 0, 0, 0);
        graphics.popState();
    }

    private void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        graphics.pushState();
        graphics.setForegroundColor(this.getIconColor());
        graphics.setLineWidthFloat(1.2f);
        Point pt = this.getIconOrigin();
        graphics.drawPolygon(new int[]{pt.x + 4, pt.y - 7, pt.x - 4, pt.y - 7, pt.x - 8, pt.y, pt.x - 5, pt.y + 7, pt.x + 4, pt.y + 7, pt.x + 8, pt.y});
        Path path = new Path(null);
        path.moveTo((float)(pt.x - 2), (float)(pt.y - 5));
        path.lineTo((float)pt.x - 5.3f, (float)pt.y + 0.5f);
        path.moveTo((float)pt.x - 3.7f, (float)pt.y + 4.5f);
        path.lineTo((float)(pt.x + 3), (float)pt.y + 4.5f);
        path.moveTo((float)pt.x + 5.0f, (float)pt.y + 0.5f);
        path.lineTo((float)pt.x + 2.0f, (float)(pt.y - 5));
        graphics.drawPath(path);
        path.dispose();
        graphics.popState();
    }

    private Point getIconOrigin() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.x + bounds.width - 11 - this.getLineWidth(), bounds.y + 12);
    }

    @Override
    public int getIconOffset() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? 22 : 0;
    }

    @Override
    protected int getTextControlMarginHeight() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? super.getTextControlMarginHeight() : 0;
    }

    @Override
    public IFigureDelegate getFigureDelegate() {
        return this.getDiagramModelArchimateObject().getType() == 0 ? this.rectangleDelegate : null;
    }
}

