/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.AbstractFigureDelegate;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class ProcessFigureDelegate
extends AbstractFigureDelegate {
    public ProcessFigureDelegate(AbstractDiagramModelObjectFigure owner) {
        super(owner);
    }

    @Override
    public void drawFigure(Graphics graphics) {
        graphics.pushState();
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        graphics.setBackgroundColor(this.getFillColor());
        Rectangle bounds = this.getBounds();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        Path path = new Path(null);
        float x1 = (float)bounds.x + (float)bounds.width * 0.7f;
        float y1 = bounds.y + bounds.height / 5;
        float y2 = bounds.y + bounds.height - bounds.height / 5;
        float lineOffset = (float)this.getLineWidth() / 2.0f;
        path.moveTo((float)bounds.x, y1);
        path.lineTo(x1, y1);
        path.lineTo(x1, (float)bounds.y);
        path.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height / 2));
        path.lineTo(x1, (float)(bounds.y + bounds.height));
        path.lineTo(x1, y2);
        path.lineTo((float)bounds.x, y2);
        path.lineTo((float)bounds.x, y1 - lineOffset);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setForegroundColor(this.getLineColor());
        graphics.setAlpha(this.getLineAlpha());
        graphics.drawPath(path);
        path.dispose();
        this.getOwner().drawIconImage(graphics, bounds, bounds.height / 5 + 1, (int)(-((float)bounds.width * 0.2f)), -(bounds.height / 5 + 1), 0);
        graphics.popState();
    }

    @Override
    public Rectangle calculateTextControlBounds() {
        Rectangle bounds = this.getBounds();
        if (((ITextPosition)this.getOwner().getDiagramModelObject()).getTextPosition() == 0) {
            bounds.y += bounds.height / 5;
        }
        return bounds;
    }
}

