/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.figures.elements;

import com.archimatetool.editor.diagram.figures.elements.DeliverableFigure;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;

public class RepresentationFigure
extends DeliverableFigure {
    protected static final int TOP_MARGIN = 12;

    @Override
    public void drawFigure(Graphics graphics) {
        if (this.getFigureDelegate() != null) {
            this.getFigureDelegate().drawFigure(graphics);
            this.drawIcon(graphics);
            return;
        }
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        graphics.setAlpha(this.getAlpha());
        if (!this.isEnabled()) {
            this.setDisabledState(graphics);
        }
        Path path = this.getFigurePath(6.0f, bounds, (float)this.getLineWidth() / 2.0f);
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillPath(path);
        this.disposeGradientPattern(graphics, gradient);
        graphics.setAlpha(this.getLineAlpha());
        graphics.setForegroundColor(this.getLineColor());
        graphics.drawPath(path);
        path.dispose();
        graphics.drawLine(bounds.x, bounds.y + 12, bounds.x + bounds.width, bounds.y + 12);
        this.drawIconImage(graphics, bounds, 12, 0, -12, 0);
        graphics.popState();
    }

    @Override
    public Rectangle calculateTextControlBounds() {
        if (this.getFigureDelegate() != null) {
            return super.calculateTextControlBounds();
        }
        Rectangle bounds = this.getBounds().getCopy();
        int textPosition = ((ITextPosition)this.getDiagramModelObject()).getTextPosition();
        if (textPosition == 0) {
            bounds.y += 12 - this.getTextControlMarginHeight() - 1;
        }
        return bounds;
    }

    @Override
    protected void drawIcon(Graphics graphics) {
        if (!this.isIconVisible()) {
            return;
        }
        super.drawIcon(graphics);
        graphics.pushState();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.getIconColor());
        Point pt = this.getIconOrigin();
        graphics.drawLine(pt.x, pt.y + 3, pt.x + 14, pt.y + 3);
        graphics.popState();
    }
}

