/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.policies;

import com.archimatetool.editor.diagram.policies.Messages;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ContainerEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;

public class BasicContainerEditPolicy
extends ContainerEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    public Command getOrphanChildrenCommand(GroupRequest request) {
        CompoundCommand result = new CompoundCommand(Messages.BasicContainerEditPolicy_0);
        IDiagramModelContainer parent = (IDiagramModelContainer)this.getHost().getModel();
        for (Object o : request.getEditParts()) {
            EditPart editPart = (EditPart)o;
            IDiagramModelObject child = (IDiagramModelObject)editPart.getModel();
            result.add((Command)new RemoveObjectCommand(parent, child));
        }
        return result;
    }

    static class RemoveObjectCommand
    extends Command {
        IDiagramModelContainer fParent;
        IDiagramModelObject fChild;
        IBounds fOldBounds;
        int fIndex;

        public RemoveObjectCommand(IDiagramModelContainer parent, IDiagramModelObject child) {
            this.fParent = parent;
            this.fChild = child;
        }

        public void execute() {
            this.fOldBounds = this.fChild.getBounds();
            this.fIndex = this.fParent.getChildren().indexOf((Object)this.fChild);
            this.fParent.getChildren().remove((Object)this.fChild);
        }

        public void redo() {
            this.fParent.getChildren().remove((Object)this.fChild);
        }

        public void undo() {
            this.fChild.setBounds(this.fOldBounds);
            this.fParent.getChildren().add(this.fIndex, (Object)this.fChild);
        }

        public void dispose() {
            this.fParent = null;
            this.fChild = null;
        }
    }
}

