/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.policies;

import com.archimatetool.editor.diagram.commands.CreateDiagramObjectCommand;
import com.archimatetool.editor.diagram.commands.SetConstraintObjectCommand;
import com.archimatetool.editor.diagram.editparts.IConstrainedSizeEditPart;
import com.archimatetool.editor.diagram.editparts.INonResizableEditPart;
import com.archimatetool.editor.diagram.policies.ConstrainedResizableEditPolicy;
import com.archimatetool.editor.diagram.policies.LockedResizableEditPolicy;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ILockable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class DiagramLayoutPolicy
extends XYLayoutEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        Rectangle bounds = (Rectangle)this.getConstraintFor(request);
        return new CreateDiagramObjectCommand(this.getHost(), request, bounds);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (this.isChildEditPartLocked(child)) {
            return new LockedResizableEditPolicy();
        }
        if (child instanceof INonResizableEditPart) {
            return new NonResizableEditPolicy();
        }
        if (child instanceof IConstrainedSizeEditPart) {
            return new ConstrainedResizableEditPolicy();
        }
        return new ResizableEditPolicy();
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (this.isChildEditPartLocked(child)) {
            return null;
        }
        if (constraint instanceof Rectangle) {
            return new SetConstraintObjectCommand(request, (IDiagramModelObject)child.getModel(), (Rectangle)constraint);
        }
        return null;
    }

    protected boolean isChildEditPartLocked(EditPart child) {
        return child.getModel() instanceof ILockable && ((ILockable)child.getModel()).isLocked();
    }

    protected AddObjectCommand createAddCommand(ChangeBoundsRequest request, EditPart childEditPart, Object constraint) {
        IDiagramModelContainer parent = (IDiagramModelContainer)this.getHost().getModel();
        IDiagramModelObject child = (IDiagramModelObject)childEditPart.getModel();
        Rectangle bounds = (Rectangle)constraint;
        if (!(parent instanceof IDiagramModel)) {
            if (bounds.x < 0) {
                bounds.x = 0;
            }
            if (bounds.y < 0) {
                bounds.y = 0;
            }
        }
        return new AddObjectCommand(parent, child, bounds);
    }

    public class AddObjectCommand
    extends Command {
        IDiagramModelContainer parent;
        IDiagramModelObject child;
        Rectangle bounds;

        public AddObjectCommand(IDiagramModelContainer parent, IDiagramModelObject child, Rectangle bounds) {
            this.parent = parent;
            this.child = child;
            this.bounds = bounds.getCopy();
        }

        public void execute() {
            this.doExecute();
            this.selectEditPart();
        }

        public void undo() {
            this.parent.getChildren().remove((Object)this.child);
        }

        public void redo() {
            this.doExecute();
        }

        protected void doExecute() {
            this.child.setBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            this.parent.getChildren().add((Object)this.child);
        }

        protected void selectEditPart() {
            Object v = DiagramLayoutPolicy.this.getHost().getViewer().getEditPartRegistry().get(this.child);
            if (v instanceof EditPart) {
                EditPart editPart = (EditPart)v;
                DiagramLayoutPolicy.this.getHost().getViewer().appendSelection(editPart);
            }
        }

        public void dispose() {
            this.parent = null;
            this.child = null;
        }
    }
}

