/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.policies.snaptogrid;

import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.tools.ConnectionBendpointTracker;

public class ExtendedConnectionBendpointTracker
extends ConnectionBendpointTracker {
    static final int MODIFIER_NO_SNAPPING = "macosx".equals(Platform.getOS()) ? 262144 : 65536;

    protected ExtendedConnectionBendpointTracker() {
    }

    public ExtendedConnectionBendpointTracker(ConnectionEditPart editpart, int i) {
        super(editpart, i);
    }

    protected boolean isSnapToGridEnabled() {
        return (Boolean)this.getCurrentViewer().getProperty("SnapToGrid.isEnabled");
    }

    protected int getSnapGridSize() {
        return ((Dimension)this.getCurrentViewer().getProperty((String)"SnapToGrid.GridSpacing")).width;
    }

    protected void updateSourceRequest() {
        Point pt = this.getLocation();
        if (this.isSnapToGridEnabled() && !this.getCurrentInput().isModKeyDown(MODIFIER_NO_SNAPPING)) {
            this.setNearestSnapPoint(pt, this.getSnapGridSize());
        }
        BendpointRequest request = (BendpointRequest)this.getSourceRequest();
        request.setLocation(pt);
    }

    protected Point setNearestSnapPoint(Point pt, double gridSize) {
        int x_offset = 0;
        int y_offset = 0;
        if (this.getCurrentViewer() != null && this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            Rectangle ca = ((FigureCanvas)this.getCurrentViewer().getControl()).getViewport().getClientArea();
            x_offset = ca.x;
            y_offset = ca.y;
            ZoomManager zm = (ZoomManager)this.getCurrentViewer().getProperty(ZoomManager.class.toString());
            if (zm != null) {
                gridSize *= zm.getZoom();
            }
        }
        pt.setX((int)((double)Math.round((double)((float)pt.x + (float)x_offset) / gridSize) * gridSize - (double)x_offset));
        pt.setY((int)((double)Math.round((double)((float)pt.y + (float)y_offset) / gridSize) * gridSize - (double)y_offset));
        return pt;
    }
}

