/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.sketch;

import com.archimatetool.editor.diagram.AbstractDiagramEditor;
import com.archimatetool.editor.diagram.sketch.BackgroundImageLayer;
import com.archimatetool.editor.diagram.sketch.ISketchEditor;
import com.archimatetool.editor.diagram.sketch.Messages;
import com.archimatetool.editor.diagram.sketch.SketchEditorContextMenuProvider;
import com.archimatetool.editor.diagram.sketch.SketchEditorPalette;
import com.archimatetool.editor.diagram.sketch.dnd.SketchDiagramTransferDropTargetListener;
import com.archimatetool.editor.diagram.sketch.editparts.SketchEditPartFactory;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.model.ISketchModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SketchEditor
extends AbstractDiagramEditor
implements ISketchEditor {
    private BackgroundImageLayer fBackgroundImageLayer;

    @Override
    public void doCreatePartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.archimatetool.help.sketchEditorHelp");
    }

    public SketchEditorPalette getPaletteRoot() {
        if (this.fPaletteRoot == null) {
            this.fPaletteRoot = new SketchEditorPalette();
        }
        return (SketchEditorPalette)this.fPaletteRoot;
    }

    public ISketchModel getModel() {
        return (ISketchModel)super.getModel();
    }

    @Override
    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new SketchEditPartFactory());
        viewer.setContents((Object)this.getModel());
        viewer.addDropTargetListener((TransferDropTargetListener)new SketchDiagramTransferDropTargetListener((EditPartViewer)viewer));
    }

    @Override
    protected void createRootEditPart(GraphicalViewer viewer) {
        super.createRootEditPart(viewer);
        ScalableFreeformRootEditPart rootPart = (ScalableFreeformRootEditPart)viewer.getRootEditPart();
        Layer layer = (Layer)rootPart.getLayer((Object)"Scalable Layers");
        this.fBackgroundImageLayer = new BackgroundImageLayer();
        layer.add((IFigure)this.fBackgroundImageLayer, (Object)"BackgroundImageLayer", 0);
        this.updateBackgroundImage();
    }

    @Override
    public void updateBackgroundImage() {
        switch (this.getModel().getBackground()) {
            case 0: {
                this.fBackgroundImageLayer.setImage(null);
                break;
            }
            case 1: {
                this.fBackgroundImageLayer.setImage(IArchiImages.ImageFactory.getImage("img/br_paper.jpg"));
                break;
            }
            case 2: {
                this.fBackgroundImageLayer.setImage(IArchiImages.ImageFactory.getImage("img/cork.jpg"));
            }
        }
    }

    @Override
    protected void registerContextMenu(GraphicalViewer viewer) {
        SketchEditorContextMenuProvider provider = new SketchEditorContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("SketchEditorContextMenuProvider", (MenuManager)provider, (ISelectionProvider)viewer);
    }

    public int getContextChangeMask() {
        return 0;
    }

    public IContext getContext(Object target) {
        return HelpSystem.getContext((String)"com.archimatetool.help.sketchEditorHelp");
    }

    public String getSearchExpression(Object target) {
        return Messages.SketchEditor_0;
    }
}

