/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.sketch.figures;

import com.archimatetool.editor.diagram.figures.AbstractLabelFigure;
import com.archimatetool.editor.diagram.figures.ToolTipFigure;
import com.archimatetool.editor.diagram.sketch.figures.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ISketchModelActor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class SketchActorFigure
extends AbstractLabelFigure {
    public SketchActorFigure(ISketchModelActor actor) {
        super((IDiagramModelObject)actor);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setAlpha(this.getAlpha());
        graphics.setForegroundColor(this.getFillColor());
        graphics.setAntialias(1);
        Rectangle bounds = this.getBounds().getCopy();
        graphics.setLineWidth(this.getLineWidth() + 1);
        bounds.height -= this.getLabel().getPreferredSize().height;
        int narrowest = Math.min(bounds.width, bounds.height);
        int diameter = narrowest / 3;
        int midX = bounds.x + bounds.width / 2;
        graphics.drawOval(midX - diameter / 2, bounds.y + 1, diameter, diameter);
        int bodyY2 = bounds.y + bounds.height - bounds.height / 3;
        graphics.drawLine(midX, bounds.y + diameter, midX, bodyY2);
        int armsY = bounds.y + diameter + bounds.height / 8;
        graphics.drawLine(midX - diameter, armsY, midX + diameter, armsY);
        graphics.drawLine(midX, bodyY2, midX - diameter, bounds.y + bounds.height);
        graphics.drawLine(midX, bodyY2, midX + diameter, bounds.y + bounds.height);
    }

    @Override
    public Rectangle calculateTextControlBounds() {
        Rectangle bounds = this.getBounds().getCopy();
        bounds.y += bounds.height - this.getLabel().getPreferredSize().height;
        bounds.height = this.getLabel().getPreferredSize().height;
        return bounds;
    }

    @Override
    public IFigure getToolTip() {
        ToolTipFigure tooltip = (ToolTipFigure)super.getToolTip();
        if (tooltip == null) {
            return null;
        }
        String text = ArchiLabelProvider.INSTANCE.getLabel(this.getDiagramModelObject());
        tooltip.setText(text);
        tooltip.setType(Messages.SketchActorFigure_0);
        return tooltip;
    }
}

