/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.sketch.figures;

import com.archimatetool.editor.diagram.figures.AbstractTextControlContainerFigure;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ISketchModelSticky;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Pattern;

public class StickyFigure
extends AbstractTextControlContainerFigure {
    public StickyFigure(ISketchModelSticky diagramModelSticky) {
        super((IDiagramModelObject)diagramModelSticky, 0);
    }

    @Override
    public void setText() {
        String text = this.getDiagramModelObject().getContent();
        ((TextFlow)this.getTextControl()).setText(StringUtils.safeString(text));
    }

    public ISketchModelSticky getDiagramModelObject() {
        return (ISketchModelSticky)super.getDiagramModelObject();
    }

    @Override
    protected void drawFigure(Graphics graphics) {
        boolean drawOutline;
        graphics.pushState();
        graphics.setAlpha(this.getAlpha());
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        boolean bl = drawOutline = this.getLineStyle() != 3;
        if (drawOutline) {
            this.setLineWidth(graphics, bounds);
            this.setLineStyle(graphics);
        }
        graphics.setBackgroundColor(this.getFillColor());
        Pattern gradient = this.applyGradientPattern(graphics, bounds);
        graphics.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        this.disposeGradientPattern(graphics, gradient);
        this.drawIconImage(graphics, bounds);
        if (drawOutline) {
            graphics.setAlpha(this.getLineAlpha());
            graphics.setForegroundColor(this.getLineColor());
            graphics.drawRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        graphics.popState();
    }

    @Override
    protected int getTextControlMarginWidth() {
        return 10;
    }
}

