/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.sketch.policies;

import com.archimatetool.editor.diagram.commands.AddDiagramModelReferenceCommand;
import com.archimatetool.editor.diagram.dnd.AbstractDNDEditPolicy;
import com.archimatetool.editor.diagram.dnd.DiagramDropRequest;
import com.archimatetool.editor.diagram.sketch.policies.Messages;
import com.archimatetool.model.IDiagramModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SketchDNDEditPolicy
extends AbstractDNDEditPolicy {
    @Override
    protected Command getDropCommand(DiagramDropRequest request) {
        if (!(request.getData() instanceof IStructuredSelection)) {
            return null;
        }
        Point pt = this.getDropLocation(request);
        int origin = pt.x;
        int x = pt.x;
        int y = pt.y;
        Object[] objects = ((IStructuredSelection)request.getData()).toArray();
        List<IDiagramModel> list = this.getDiagramRefsToAdd(objects);
        CompoundCommand result = new CompoundCommand(Messages.SketchDNDEditPolicy_0);
        for (IDiagramModel diagramModel : list) {
            result.add((Command)new AddDiagramModelReferenceCommand(this.getTargetContainer(), diagramModel, x, y));
            if ((x += 150) <= origin + 400) continue;
            x = origin;
            y += 100;
        }
        return result;
    }

    protected List<IDiagramModel> getDiagramRefsToAdd(Object[] objects) {
        ArrayList<IDiagramModel> list = new ArrayList<IDiagramModel>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IDiagramModel && object != this.getTargetDiagramModel() && !list.contains(object)) {
                list.add((IDiagramModel)object);
            }
            ++n2;
        }
        return list;
    }
}

