/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.tools;

import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IIconic;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class FormatPainterInfo {
    public static FormatPainterInfo INSTANCE = new FormatPainterInfo();
    private IDiagramModelComponent sourceComponent;
    private byte[] sourceImageBytes;
    private RGB cursorColor;
    private Cursor coloredCursor;
    private Cursor defaultCursor;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    private FormatPainterInfo() {
    }

    public void reset() {
        this.setSourceComponent(null);
        this.fireUpdated();
    }

    void updateWithSourceComponent(IDiagramModelComponent component) {
        this.setSourceComponent(component);
        this.updateColoredCursor();
        this.fireUpdated();
    }

    Cursor getCursor() {
        return this.hasSourceComponent() ? this.coloredCursor : this.getDefaultCursor();
    }

    private Cursor getDefaultCursor() {
        if (this.defaultCursor == null) {
            ImageData id = IArchiImages.ImageFactory.getImage("img/formatpainter-grey-cursor.png").getImageData(ImageFactory.getCursorDeviceZoom());
            this.defaultCursor = new Cursor(null, id, 0, id.height - 1);
        }
        return this.defaultCursor;
    }

    boolean hasSourceComponent() {
        return this.getSourceComponent() != null;
    }

    IDiagramModelComponent getSourceComponent() {
        return this.sourceComponent;
    }

    byte[] getSourceImageBytes() {
        return this.sourceImageBytes;
    }

    RGB getCursorColor() {
        return this.cursorColor;
    }

    private void setSourceComponent(IDiagramModelComponent component) {
        IDiagramModelComponent iDiagramModelComponent;
        IArchiveManager sourceArchiveManager;
        IIconic iconic;
        this.sourceComponent = null;
        this.sourceImageBytes = null;
        this.cursorColor = null;
        if (component != null) {
            this.sourceComponent = (IDiagramModelComponent)component.getCopy();
        }
        if (component instanceof IIconic && (iconic = (IIconic)component).getImagePath() != null && (sourceArchiveManager = (IArchiveManager)component.getAdapter(IArchiveManager.class)) != null) {
            this.sourceImageBytes = sourceArchiveManager.getBytesFromEntry(iconic.getImagePath());
        }
        if ((iDiagramModelComponent = this.sourceComponent) instanceof IDiagramModelConnection) {
            IDiagramModelConnection dmc = (IDiagramModelConnection)iDiagramModelComponent;
            String colorValue = dmc.getLineColor();
            this.cursorColor = ColorFactory.convertStringToRGB(colorValue);
            if (this.cursorColor == null) {
                this.cursorColor = ColorFactory.getDefaultLineColor(this.sourceComponent).getRGB();
            }
        } else {
            IDiagramModelComponent iDiagramModelComponent2 = this.sourceComponent;
            if (iDiagramModelComponent2 instanceof IDiagramModelObject) {
                IDiagramModelObject dmo = (IDiagramModelObject)iDiagramModelComponent2;
                String colorValue = dmo.getFillColor();
                this.cursorColor = ColorFactory.convertStringToRGB(colorValue);
                if (this.cursorColor == null) {
                    this.cursorColor = ColorFactory.getDefaultFillColor(this.sourceComponent).getRGB();
                }
            }
        }
    }

    private void updateColoredCursor() {
        if (this.coloredCursor != null && !this.coloredCursor.isDisposed()) {
            this.coloredCursor.dispose();
        }
        ImageData cursorImageData = IArchiImages.ImageFactory.getImage("img/formatpainter-cursor.png").getImageData(ImageFactory.getCursorDeviceZoom());
        if (this.getCursorColor() != null) {
            PaletteData pData = cursorImageData.palette;
            int whitePixel = pData.getPixel(new RGB(255, 255, 255));
            int fillColor = pData.getPixel(this.getCursorColor());
            int i = 0;
            while (i < cursorImageData.width) {
                int j = 0;
                while (j < cursorImageData.height) {
                    if (cursorImageData.getPixel(i, j) == whitePixel) {
                        cursorImageData.setPixel(i, j, fillColor);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.coloredCursor = new Cursor(null, cursorImageData, 0, cursorImageData.height - 1);
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    private void fireUpdated() {
        this.listeners.firePropertyChange("FORMAT_PAINTER_UPDATED", false, true);
    }

    void dispose() {
        if (this.defaultCursor != null) {
            this.defaultCursor.dispose();
        }
        if (this.coloredCursor != null) {
            this.coloredCursor.dispose();
        }
    }
}

