/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.tools;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.ArchimateDiagramModelFactory;
import com.archimatetool.editor.diagram.commands.CreateDiagramArchimateConnectionWithDialogCommand;
import com.archimatetool.editor.diagram.editparts.AbstractBaseEditPart;
import com.archimatetool.editor.diagram.editparts.diagram.GroupEditPart;
import com.archimatetool.editor.diagram.figures.IContainerFigure;
import com.archimatetool.editor.diagram.tools.MagicConnectionModelFactory;
import com.archimatetool.editor.diagram.tools.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.editor.ui.services.ComponentSelectionManager;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MagicConnectionCreationTool
extends ConnectionCreationTool {
    private static Cursor cursor = new Cursor(null, IArchiImages.ImageFactory.getImage("img/magic-connector-cursor.png").getImageData(ImageFactory.getCursorDeviceZoom()), 0, 0);
    private boolean fSetRelationshipTypeWhenHoveringOnConnectionMenuItem;
    private boolean fCanSetCurrentCommand = true;

    public MagicConnectionCreationTool() {
        this.setDefaultCursor(cursor);
        this.setDisabledCursor(cursor);
    }

    protected boolean handleCreateConnection() {
        this.getFactory().clear();
        this.fCanSetCurrentCommand = true;
        Command endCommand = this.getCommand();
        this.setCurrentCommand(endCommand);
        CreateConnectionRequest request = (CreateConnectionRequest)this.getTargetRequest();
        EditPart sourceEditPart = request.getSourceEditPart();
        EditPart targetEditPart = request.getTargetEditPart();
        if (sourceEditPart == null) {
            this.eraseSourceFeedback();
            return false;
        }
        IDiagramModelArchimateComponent sourceDiagramModelComponent = (IDiagramModelArchimateComponent)sourceEditPart.getModel();
        if (targetEditPart == null) {
            return this.createElementAndConnection(sourceDiagramModelComponent, request.getLocation());
        }
        if (targetEditPart.getModel() instanceof IDiagramModelArchimateComponent) {
            return this.createConnection(request, sourceDiagramModelComponent, (IDiagramModelArchimateComponent)targetEditPart.getModel());
        }
        this.eraseSourceFeedback();
        return false;
    }

    protected void setTargetEditPart(EditPart editpart) {
        IArchimateConcept targetConcept;
        IArchimateConcept sourceConcept;
        EditPart sourceEditPart;
        if (editpart != null && !(editpart.getModel() instanceof IDiagramModelArchimateComponent)) {
            editpart = null;
        }
        if (editpart != null && (sourceEditPart = ((CreateConnectionRequest)this.getSourceRequest()).getSourceEditPart()) != null && sourceEditPart.getModel() instanceof IDiagramModelArchimateComponent && editpart.getModel() instanceof IDiagramModelArchimateComponent && ArchimateModelUtils.hasDirectRelationship((IArchimateConcept)(sourceConcept = ((IDiagramModelArchimateComponent)sourceEditPart.getModel()).getArchimateConcept()), (IArchimateConcept)(targetConcept = ((IDiagramModelArchimateComponent)editpart.getModel()).getArchimateConcept()))) {
            editpart = null;
        }
        super.setTargetEditPart(editpart);
    }

    protected void setCurrentCommand(Command c) {
        if (this.fCanSetCurrentCommand) {
            super.setCurrentCommand(c);
        }
    }

    private boolean createConnection(CreateConnectionRequest request, IDiagramModelArchimateComponent sourceDiagramModelComponent, IDiagramModelArchimateComponent targetDiagramModelComponent) {
        this.fSetRelationshipTypeWhenHoveringOnConnectionMenuItem = false;
        this.fCanSetCurrentCommand = false;
        Menu menu = new Menu(this.getCurrentViewer().getControl());
        this.addConnectionActions(menu, sourceDiagramModelComponent, targetDiagramModelComponent);
        menu.setVisible(true);
        Display display = menu.getDisplay();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (PlatformUtils.isWindows()) {
            while (display.readAndDispatch()) {
            }
        }
        if (!menu.isDisposed()) {
            menu.dispose();
        }
        this.fCanSetCurrentCommand = true;
        this.eraseSourceFeedback();
        if (this.getFactory().getObjectType() == null) {
            this.getFactory().clear();
            return false;
        }
        if (this.getFactory().swapSourceAndTarget()) {
            CreateDiagramArchimateConnectionWithDialogCommand cmd = (CreateDiagramArchimateConnectionWithDialogCommand)this.getCurrentCommand();
            cmd.swapSourceAndTargetConcepts();
        }
        this.executeCurrentCommand();
        this.getFactory().clear();
        return true;
    }

    private boolean createElementAndConnection(IDiagramModelArchimateComponent sourceDiagramModelComponent, Point location) {
        EditPartViewer viewer = this.getCurrentViewer();
        GraphicalEditPart targetEditPart = (GraphicalEditPart)viewer.findObjectAt(this.getCurrentInput().getMouseLocation());
        IDiagramModel parent = sourceDiagramModelComponent.getDiagramModel();
        if (targetEditPart instanceof GroupEditPart) {
            parent = (IDiagramModelContainer)targetEditPart.getModel();
        } else if (targetEditPart instanceof AbstractBaseEditPart) {
            targetEditPart = (GraphicalEditPart)targetEditPart.getParent();
            parent = (IDiagramModelContainer)targetEditPart.getModel();
        }
        boolean elementsFirst = ArchiPlugin.getInstance().getPreferenceStore().getBoolean("polarityMagicConnector");
        boolean modKeyPressed = this.getCurrentInput().isModKeyDown(SWT.MOD1);
        Menu menu = new Menu(this.getCurrentViewer().getControl());
        if (elementsFirst ^= modKeyPressed) {
            this.fSetRelationshipTypeWhenHoveringOnConnectionMenuItem = false;
            this.addElementActions(menu, sourceDiagramModelComponent);
        } else {
            this.fSetRelationshipTypeWhenHoveringOnConnectionMenuItem = true;
            this.addConnectionActions(menu, sourceDiagramModelComponent);
        }
        menu.setVisible(true);
        Display display = menu.getDisplay();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (PlatformUtils.isWindows()) {
            while (display.readAndDispatch()) {
            }
        }
        if (!menu.isDisposed()) {
            menu.dispose();
        }
        this.eraseSourceFeedback();
        if (this.getFactory().getElementType() == null || this.getFactory().getRelationshipType() == null) {
            this.getFactory().clear();
            return false;
        }
        CompoundCommand cmd = new CompoundCommand(Messages.MagicConnectionCreationTool_6);
        if (targetEditPart.getFigure() instanceof IContainerFigure) {
            ((IContainerFigure)targetEditPart.getFigure()).translateMousePointToRelative((Translatable)location);
        } else {
            IFigure contentPane = targetEditPart.getContentPane();
            contentPane.translateToRelative((Translatable)location);
        }
        CreateNewDiagramObjectCommand cmd1 = new CreateNewDiagramObjectCommand((IDiagramModelContainer)parent, this.getFactory().getElementType(), location, viewer);
        CreateNewConnectionCommand cmd2 = new CreateNewConnectionCommand(sourceDiagramModelComponent, (IDiagramModelArchimateComponent)cmd1.getNewObject(), this.getFactory().getRelationshipType());
        cmd.add((Command)cmd1);
        cmd.add((Command)cmd2);
        this.executeCommand((Command)cmd);
        this.getFactory().clear();
        return true;
    }

    private void addConnectionActions(Menu menu, IDiagramModelArchimateComponent sourceDiagramModelComponent) {
        EClass[] eClassArray = ArchimateModelUtils.getRelationsClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass relationshipType = eClassArray[n2];
            if (ArchimateModelUtils.isValidRelationshipStart((IArchimateConcept)sourceDiagramModelComponent.getArchimateConcept(), (EClass)relationshipType)) {
                MenuItem item = this.addConnectionAction(menu, relationshipType, false);
                Menu subMenu = new Menu(item);
                item.setMenu(subMenu);
                this.addConnectionActions(subMenu, Messages.MagicConnectionCreationTool_7, sourceDiagramModelComponent, ArchimateModelUtils.getStrategyClasses(), relationshipType);
                this.addConnectionActions(subMenu, Messages.MagicConnectionCreationTool_0, sourceDiagramModelComponent, ArchimateModelUtils.getBusinessClasses(), relationshipType);
                this.addConnectionActions(subMenu, Messages.MagicConnectionCreationTool_1, sourceDiagramModelComponent, ArchimateModelUtils.getApplicationClasses(), relationshipType);
                this.addConnectionActions(subMenu, Messages.MagicConnectionCreationTool_2, sourceDiagramModelComponent, ArchimateModelUtils.getTechnologyClasses(), relationshipType);
                this.addConnectionActions(subMenu, Messages.MagicConnectionCreationTool_9, sourceDiagramModelComponent, ArchimateModelUtils.getPhysicalClasses(), relationshipType);
                this.addConnectionActions(subMenu, Messages.MagicConnectionCreationTool_3, sourceDiagramModelComponent, ArchimateModelUtils.getMotivationClasses(), relationshipType);
                this.addConnectionActions(subMenu, Messages.MagicConnectionCreationTool_4, sourceDiagramModelComponent, ArchimateModelUtils.getImplementationMigrationClasses(), relationshipType);
                this.addConnectionActions(subMenu, Messages.MagicConnectionCreationTool_8, sourceDiagramModelComponent, this.getOtherAndConnectorClasses(), relationshipType);
                if (subMenu.getItemCount() == 0) {
                    item.dispose();
                }
            }
            ++n2;
        }
    }

    private void addConnectionActions(Menu menu, String menuText, IDiagramModelArchimateComponent sourceDiagramModelComponent, EClass[] list, EClass relationshipType) {
        if (!this.isAllowedTargetTypeInViewpoint(sourceDiagramModelComponent, relationshipType)) {
            return;
        }
        MenuItem item = new MenuItem(menu, 64);
        item.setText(menuText);
        Menu subMenu = new Menu(item);
        item.setMenu(subMenu);
        EClass[] eClassArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            IArchimateConcept targetConcept;
            IArchimateConcept sourceConcept;
            EClass type = eClassArray[n2];
            if (this.isAllowedTargetTypeInViewpoint(sourceDiagramModelComponent, type) && ArchimateModelUtils.isValidRelationship((IArchimateConcept)(sourceConcept = sourceDiagramModelComponent.getArchimateConcept()), (IArchimateConcept)(targetConcept = (IArchimateConcept)IArchimateFactory.eINSTANCE.create(type)), (EClass)relationshipType)) {
                this.addElementAction(subMenu, type);
            }
            ++n2;
        }
        if (subMenu.getItemCount() == 0) {
            item.dispose();
        }
    }

    private void addElementActions(Menu menu, IDiagramModelArchimateComponent sourceDiagramModelComponent) {
        this.addElementActions(menu, Messages.MagicConnectionCreationTool_7, sourceDiagramModelComponent, ArchimateModelUtils.getStrategyClasses());
        this.addElementActions(menu, Messages.MagicConnectionCreationTool_0, sourceDiagramModelComponent, ArchimateModelUtils.getBusinessClasses());
        this.addElementActions(menu, Messages.MagicConnectionCreationTool_1, sourceDiagramModelComponent, ArchimateModelUtils.getApplicationClasses());
        this.addElementActions(menu, Messages.MagicConnectionCreationTool_2, sourceDiagramModelComponent, ArchimateModelUtils.getTechnologyClasses());
        this.addElementActions(menu, Messages.MagicConnectionCreationTool_3, sourceDiagramModelComponent, ArchimateModelUtils.getMotivationClasses());
        this.addElementActions(menu, Messages.MagicConnectionCreationTool_4, sourceDiagramModelComponent, ArchimateModelUtils.getImplementationMigrationClasses());
        this.addElementActions(menu, Messages.MagicConnectionCreationTool_8, sourceDiagramModelComponent, this.getOtherAndConnectorClasses());
    }

    private void addElementActions(Menu menu, String menuText, IDiagramModelArchimateComponent sourceDiagramModelComponent, EClass[] list) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText(menuText);
        Menu subMenu = new Menu(item);
        item.setMenu(subMenu);
        EClass[] eClassArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            EClass type = eClassArray[n2];
            if (this.isAllowedTargetTypeInViewpoint(sourceDiagramModelComponent, type)) {
                MenuItem subItem = this.addElementAction(subMenu, type);
                Menu childSubMenu = new Menu(subItem);
                subItem.setMenu(childSubMenu);
                IArchimateConcept sourceConcept = sourceDiagramModelComponent.getArchimateConcept();
                IArchimateConcept targetConcept = (IArchimateConcept)IArchimateFactory.eINSTANCE.create(type);
                EClass[] eClassArray2 = ArchimateModelUtils.getValidRelationships((IArchimateConcept)sourceConcept, (IArchimateConcept)targetConcept);
                int n3 = eClassArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    EClass eClass = eClassArray2[n4];
                    if (this.isAllowedTargetTypeInViewpoint(sourceDiagramModelComponent, eClass)) {
                        this.addConnectionAction(childSubMenu, eClass, false);
                    }
                    ++n4;
                }
                if (childSubMenu.getItemCount() == 0) {
                    subItem.dispose();
                }
            }
            ++n2;
        }
        if (subMenu.getItemCount() == 0) {
            item.dispose();
        }
    }

    private MenuItem addElementAction(Menu menu, final EClass type) {
        final MenuItem item = new MenuItem(menu, 64);
        item.setText(ArchiLabelProvider.INSTANCE.getDefaultName(type));
        item.setImage(ArchiLabelProvider.INSTANCE.getImage(type));
        item.addArmListener(new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                if (!MagicConnectionCreationTool.this.fSetRelationshipTypeWhenHoveringOnConnectionMenuItem) {
                    MagicConnectionCreationTool.this.getFactory().setElementType(type);
                }
                ComponentSelectionManager.INSTANCE.fireSelectionEvent(item, type);
            }
        });
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MagicConnectionCreationTool.this.getFactory().setElementType(type);
            }
        });
        return item;
    }

    private void addConnectionActions(Menu menu, IDiagramModelArchimateComponent sourceDiagramModelComponent, IDiagramModelArchimateComponent targetDiagramModelComponent) {
        EClass type;
        ArrayList<MenuItem> forward = new ArrayList<MenuItem>();
        ArrayList<MenuItem> reverse = new ArrayList<MenuItem>();
        EClass[] eClassArray = ArchimateModelUtils.getValidRelationships((IArchimateConcept)sourceDiagramModelComponent.getArchimateConcept(), (IArchimateConcept)targetDiagramModelComponent.getArchimateConcept());
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            type = eClassArray[n2];
            if (this.isAllowedTargetTypeInViewpoint(sourceDiagramModelComponent, type)) {
                forward.add(this.addConnectionAction(menu, type, false));
            }
            ++n2;
        }
        eClassArray = ArchimateModelUtils.getValidRelationships((IArchimateConcept)targetDiagramModelComponent.getArchimateConcept(), (IArchimateConcept)sourceDiagramModelComponent.getArchimateConcept());
        n = eClassArray.length;
        n2 = 0;
        while (n2 < n) {
            type = eClassArray[n2];
            if (this.isAllowedTargetTypeInViewpoint(sourceDiagramModelComponent, type)) {
                reverse.add(this.addConnectionAction(menu, type, true));
            }
            ++n2;
        }
        if (!forward.isEmpty() && !reverse.isEmpty()) {
            new MenuItem(menu, 2, forward.size());
        }
    }

    private MenuItem addConnectionAction(Menu menu, final EClass relationshipType, final boolean reverseDirection) {
        final MenuItem item = new MenuItem(menu, 64);
        item.setText(ArchiLabelProvider.INSTANCE.getRelationshipPhrase(relationshipType, reverseDirection));
        item.setImage(ArchiLabelProvider.INSTANCE.getImage(relationshipType));
        item.addArmListener(new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                if (MagicConnectionCreationTool.this.fSetRelationshipTypeWhenHoveringOnConnectionMenuItem) {
                    MagicConnectionCreationTool.this.getFactory().setRelationshipType(relationshipType);
                }
                ComponentSelectionManager.INSTANCE.fireSelectionEvent(item, relationshipType);
            }
        });
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MagicConnectionCreationTool.this.getFactory().setRelationshipType(relationshipType);
                MagicConnectionCreationTool.this.getFactory().setSwapSourceAndTarget(reverseDirection);
            }
        });
        return item;
    }

    private EClass[] getOtherAndConnectorClasses() {
        ArrayList<EClass> list = new ArrayList<EClass>();
        list.addAll(Arrays.asList(ArchimateModelUtils.getOtherClasses()));
        list.addAll(Arrays.asList(ArchimateModelUtils.getConnectorClasses()));
        return list.toArray(new EClass[0]);
    }

    private boolean isAllowedTargetTypeInViewpoint(IDiagramModelArchimateComponent diagramComponent, EClass type) {
        if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewpointsHideMagicConnectorElements")) {
            return true;
        }
        return ViewpointManager.INSTANCE.isAllowedConceptForDiagramModel((IArchimateDiagramModel)diagramComponent.getDiagramModel(), type);
    }

    protected MagicConnectionModelFactory getFactory() {
        return (MagicConnectionModelFactory)super.getFactory();
    }

    protected void eraseSourceFeedback() {
        this.getSourceRequest().setType((Object)"connection end");
        super.eraseSourceFeedback();
    }

    private static class CreateNewConnectionCommand
    extends Command {
        private IDiagramModelArchimateConnection fConnection;
        private IDiagramModelArchimateComponent fSource;
        private IDiagramModelArchimateComponent fTarget;
        private EClass fTemplate;

        CreateNewConnectionCommand(IDiagramModelArchimateComponent source, IDiagramModelArchimateComponent target, EClass type) {
            this.fSource = source;
            this.fTarget = target;
            this.fTemplate = type;
        }

        public void execute() {
            this.fConnection = (IDiagramModelArchimateConnection)new ArchimateDiagramModelFactory(this.fTemplate).getNewObject();
            this.fConnection.connect((IConnectable)this.fSource, (IConnectable)this.fTarget);
            this.fConnection.addArchimateConceptToModel(null);
        }

        public void redo() {
            this.fConnection.reconnect();
            this.fConnection.addArchimateConceptToModel(null);
        }

        public void undo() {
            this.fConnection.disconnect();
            this.fConnection.removeArchimateConceptFromModel();
        }

        public void dispose() {
            this.fConnection = null;
            this.fSource = null;
            this.fTarget = null;
            this.fTemplate = null;
        }
    }

    private static class CreateNewDiagramObjectCommand
    extends Command {
        private IDiagramModelContainer fParent;
        private IDiagramModelArchimateObject fChild;
        private EClass fTemplate;
        private EditPartViewer fViewer;

        CreateNewDiagramObjectCommand(IDiagramModelContainer parent, EClass type, Point location, EditPartViewer viewer) {
            this.fParent = parent;
            this.fTemplate = type;
            this.fViewer = viewer;
            this.fChild = (IDiagramModelArchimateObject)new ArchimateDiagramModelFactory(this.fTemplate).getNewObject();
            this.fChild.getBounds().setLocation(location.x, location.y);
        }

        IDiagramModelArchimateObject getNewObject() {
            return this.fChild;
        }

        public void execute() {
            EditPart editPart;
            this.redo();
            if (this.fViewer != null && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("editNameOnNewObject") && (editPart = (EditPart)this.fViewer.getEditPartRegistry().get(this.fChild)) != null) {
                Display.getCurrent().asyncExec(() -> {
                    this.fViewer.select(editPart);
                    Request directEditRequest = new Request((Object)"direct edit");
                    editPart.performRequest(directEditRequest);
                });
            }
        }

        public void undo() {
            this.fParent.getChildren().remove((Object)this.fChild);
            this.fChild.removeArchimateConceptFromModel();
        }

        public void redo() {
            this.fParent.getChildren().add((Object)this.fChild);
            this.fChild.addArchimateConceptToModel(null);
        }

        public void dispose() {
            this.fParent = null;
            this.fChild = null;
            this.fTemplate = null;
            this.fViewer = null;
        }
    }
}

