/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.util;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.commands.IAnimatableCommand;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RoutingAnimator;
import org.eclipse.draw2d.RoutingListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CompoundCommand;

public final class AnimationUtil {
    public static boolean supportsAnimation() {
        return true;
    }

    public static boolean doAnimate() {
        return ArchiPlugin.getInstance().getPreferenceStore().getBoolean("animateView");
    }

    public static int animationSpeed() {
        return ArchiPlugin.getInstance().getPreferenceStore().getInt("animationViewTime");
    }

    public static void registerCommandStack(CommandStack stack) {
        if (!AnimationUtil.supportsAnimation()) {
            return;
        }
        stack.addCommandStackEventListener(new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                if (AnimationUtil.doAnimate()) {
                    if (event.getDetail() == 4 || event.getDetail() == 2) {
                        if (this.isAnimatableCommand(event.getCommand())) {
                            Animation.markBegin();
                        }
                    } else if ((event.getDetail() == 32 || event.getDetail() == 16) && this.isAnimatableCommand(event.getCommand())) {
                        Animation.run((int)AnimationUtil.animationSpeed());
                    }
                }
            }

            private boolean isAnimatableCommand(Command cmd) {
                if (cmd instanceof CompoundCommand && ((CompoundCommand)cmd).canExecute()) {
                    for (Object command : ((CompoundCommand)cmd).getCommands()) {
                        if (command instanceof IAnimatableCommand) continue;
                        return false;
                    }
                    return true;
                }
                return cmd instanceof IAnimatableCommand;
            }
        });
    }

    public static void addFigureForAnimation(IFigure figure) {
        if (AnimationUtil.supportsAnimation()) {
            figure.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        }
    }

    public static void addConnectionForRoutingAnimation(PolylineConnection connection) {
        if (AnimationUtil.supportsAnimation()) {
            connection.addRoutingListener((RoutingListener)RoutingAnimator.getDefault());
        }
    }
}

