/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.util;

import com.archimatetool.editor.diagram.DiagramEditorFactoryExtensionHandler;
import com.archimatetool.editor.diagram.IDiagramEditorFactory;
import com.archimatetool.editor.diagram.editparts.ArchimateDiagramEditPartFactory;
import com.archimatetool.editor.diagram.sketch.editparts.SketchEditPartFactory;
import com.archimatetool.editor.diagram.util.ModelReferencedImage;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.ISketchModel;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class DiagramUtils {
    public static GraphicalViewerImpl createViewer(IDiagramModel model, Composite parent) {
        Object editPartFactory = null;
        if (model instanceof IArchimateDiagramModel) {
            editPartFactory = new ArchimateDiagramEditPartFactory();
        } else if (model instanceof ISketchModel) {
            editPartFactory = new SketchEditPartFactory();
        } else {
            IDiagramEditorFactory factory = DiagramEditorFactoryExtensionHandler.INSTANCE.getFactory(model);
            if (factory != null) {
                editPartFactory = factory.createEditPartFactory();
            }
        }
        if (editPartFactory == null) {
            throw new RuntimeException("Unsupported model type");
        }
        GraphicalViewerImpl viewer = new GraphicalViewerImpl();
        viewer.createControl(parent);
        viewer.setEditPartFactory((EditPartFactory)editPartFactory);
        FreeformGraphicalRootEditPart rootPart = new FreeformGraphicalRootEditPart();
        viewer.setRootEditPart((RootEditPart)rootPart);
        viewer.setContents((Object)model);
        viewer.flush();
        return viewer;
    }

    public static Image createImage(IDiagramModel model, double scale, int margin) {
        return DiagramUtils.createModelReferencedImage(model, scale, margin).getImage();
    }

    public static ModelReferencedImage createModelReferencedImage(IDiagramModel model, double scale, int margin) {
        Shell shell = new Shell();
        shell.setLayout((Layout)new FillLayout());
        GraphicalViewerImpl viewer = DiagramUtils.createViewer(model, (Composite)shell);
        ModelReferencedImage image = DiagramUtils.createModelReferencedImage((GraphicalViewer)viewer, scale, margin);
        shell.dispose();
        return image;
    }

    public static Image createImage(GraphicalViewer graphicalViewer, double scale, int margin) {
        return DiagramUtils.createModelReferencedImage(graphicalViewer, scale, margin).getImage();
    }

    private static ModelReferencedImage createModelReferencedImage(GraphicalViewer graphicalViewer, double scale, int margin) {
        LayerManager layerManager = (LayerManager)graphicalViewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure rootFigure = layerManager.getLayer((Object)"Printable Layers");
        return DiagramUtils.createModelReferencedImage(rootFigure, scale, margin);
    }

    public static Image createImage(IFigure figure, double scale, int margin) {
        return DiagramUtils.createModelReferencedImage(figure, scale, margin).getImage();
    }

    private static ModelReferencedImage createModelReferencedImage(IFigure figure, double scale, int margin) {
        Rectangle bounds;
        if (scale <= 0.0) {
            scale = 1.0;
        }
        if (scale > 5.0) {
            scale = 5.0;
        }
        if ((bounds = DiagramUtils.getMinimumBounds(figure)) == null) {
            bounds = new Rectangle(0, 0, 100, 100);
        } else {
            bounds.expand((double)margin / scale, (double)margin / scale);
        }
        Image image = new Image((Device)Display.getDefault(), (int)((double)bounds.width * scale), (int)((double)bounds.height * scale));
        GC gc = new GC((Drawable)image);
        SWTGraphics graphics = new SWTGraphics(gc);
        if (scale != 1.0) {
            graphics.scale(scale);
        }
        graphics.translate(bounds.x * -1, bounds.y * -1);
        figure.paint((Graphics)graphics);
        gc.dispose();
        graphics.dispose();
        return new ModelReferencedImage(image, bounds);
    }

    public static Rectangle getDiagramExtents(GraphicalViewer graphicalViewer) {
        LayerManager layerManager = (LayerManager)graphicalViewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure rootFigure = layerManager.getLayer((Object)"Printable Layers");
        Rectangle r = DiagramUtils.getMinimumBounds(rootFigure);
        return r == null ? new Rectangle(0, 0, 100, 100) : r;
    }

    public static Rectangle getMinimumBounds(IFigure figure) {
        if (!(figure instanceof FreeformFigure)) {
            return figure.getBounds();
        }
        Rectangle minimumBounds = null;
        for (Object child : figure.getChildren()) {
            Rectangle bounds = child instanceof FreeformFigure ? DiagramUtils.getMinimumBounds((IFigure)child) : ((IFigure)child).getBounds();
            if (bounds == null) continue;
            if (minimumBounds == null) {
                minimumBounds = new Rectangle(bounds);
                continue;
            }
            minimumBounds.union(bounds);
        }
        return minimumBounds;
    }
}

