/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.wizard;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.IImageExportProvider;
import com.archimatetool.editor.diagram.ImageExportProviderManager;
import com.archimatetool.editor.diagram.wizard.Messages;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportAsImagePage
extends WizardPage {
    private static String HELP_ID = "com.archimatetool.help.ExportAsImagePage";
    private Text fFileTextField;
    private ComboViewer fComboFormatViewer;
    private Group fSettingsGroup;
    private Map<ImageExportProviderManager.ImageExportProviderInfo, Composite> fSettingComposites = new HashMap<ImageExportProviderManager.ImageExportProviderInfo, Composite>();
    private List<ImageExportProviderManager.ImageExportProviderInfo> fImageProviders = ImageExportProviderManager.getImageExportProviders();
    private ImageExportProviderManager.ImageExportProviderInfo fSelectedProvider;
    private Shell fTempShell;
    private IFigure fFigure;
    private String fName;
    private IImageExportProvider.IExportDialogAdapter fExportDialogPageAdapter = new IImageExportProvider.IExportDialogAdapter(){

        @Override
        public void setErrorMessage(String message) {
            ExportAsImagePage.this.setErrorMessage(message);
        }
    };
    private static final String PREFS_LAST_PROVIDER = "ExportImageLastProvider";
    private static final String PREFS_LAST_FOLDER = "ExportImageLastFolder";

    public ExportAsImagePage(IFigure figure, String name) {
        super("ExportAsImagePage");
        this.fFigure = figure;
        this.fName = name;
        if (!StringUtils.isSet(this.fName)) {
            this.fName = "Image";
        }
        this.setTitle(Messages.ExportAsImagePage_0);
        this.setDescription(Messages.ExportAsImagePage_1);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/exportdir_wiz.png"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, HELP_ID);
        Group exportGroup = new Group(container, 0);
        exportGroup.setText(Messages.ExportAsImagePage_2);
        exportGroup.setLayout((Layout)new GridLayout(3, false));
        exportGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)exportGroup, 0);
        label.setText(Messages.ExportAsImagePage_3);
        this.fFileTextField = UIUtils.createSingleTextControl((Composite)exportGroup, 2048, false);
        this.fFileTextField.setLayoutData((Object)new GridData(768));
        String lastFolder = ArchiPlugin.getInstance().getPreferenceStore().getString(PREFS_LAST_FOLDER);
        if (StringUtils.isSet(lastFolder)) {
            File file = new File(lastFolder);
            this.fFileTextField.setText(new File(file, this.fName).getAbsolutePath());
        } else {
            this.fFileTextField.setText(new File(System.getProperty("user.home"), this.fName).getAbsolutePath());
        }
        this.fFileTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAsImagePage.this.validateFields();
            }
        });
        Button fileButton = new Button((Composite)exportGroup, 8);
        fileButton.setText(Messages.ExportAsImagePage_4);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = ExportAsImagePage.this.chooseFile();
                if (file != null) {
                    ExportAsImagePage.this.fFileTextField.setText(file.getPath());
                }
            }
        });
        label = new Label((Composite)exportGroup, 0);
        label.setText(Messages.ExportAsImagePage_5);
        this.fComboFormatViewer = this.createFormatComboViewer((Composite)exportGroup);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fComboFormatViewer.getControl().setLayoutData((Object)gd);
        this.fSettingsGroup = new Group(container, 0);
        this.fSettingsGroup.setLayoutData((Object)new GridData(1808));
        this.fSettingsGroup.setLayout((Layout)new GridLayout());
        this.fSettingsGroup.setText(Messages.ExportAsImagePage_6);
        this.validateFields();
        if (!this.fImageProviders.isEmpty()) {
            String selectedProviderID = ArchiPlugin.getInstance().getPreferenceStore().getString(PREFS_LAST_PROVIDER);
            ImageExportProviderManager.ImageExportProviderInfo provider = this.getImageProviderInfoFromID(selectedProviderID);
            if (provider == null) {
                provider = this.fImageProviders.get(0);
            }
            this.fComboFormatViewer.setSelection((ISelection)new StructuredSelection((Object)provider));
        }
    }

    private ComboViewer createFormatComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(new Combo(parent, 2056));
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ExportAsImagePage.this.fImageProviders.toArray();
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ImageExportProviderManager.ImageExportProviderInfo)element).getLabel();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImageExportProviderManager.ImageExportProviderInfo provider = (ImageExportProviderManager.ImageExportProviderInfo)((IStructuredSelection)event.getSelection()).getFirstElement();
                ExportAsImagePage.this.providerChanged(provider);
            }
        });
        viewer.setInput((Object)"");
        return viewer;
    }

    private void providerChanged(ImageExportProviderManager.ImageExportProviderInfo provider) {
        if (this.fSelectedProvider != provider) {
            this.fSelectedProvider = provider;
            String filename = this.fFileTextField.getText();
            if (filename.length() > 0) {
                block0: for (ImageExportProviderManager.ImageExportProviderInfo info : this.fImageProviders) {
                    for (String ext : info.getExtensions()) {
                        int index;
                        if (!filename.toLowerCase().endsWith("." + ext) || (index = filename.toLowerCase().lastIndexOf("." + ext)) == -1) continue;
                        filename = filename.substring(0, index);
                        continue block0;
                    }
                }
                this.fFileTextField.setText(filename + "." + this.fSelectedProvider.getExtensions().get(0));
            }
            Control[] controlArray = this.fSettingsGroup.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setVisible(false);
                if (this.fTempShell == null) {
                    this.fTempShell = new Shell();
                }
                child.setParent((Composite)this.fTempShell);
                ++n2;
            }
            Composite settingsComposite = null;
            if (this.fSettingComposites.containsKey(this.fSelectedProvider)) {
                settingsComposite = this.fSettingComposites.get(this.fSelectedProvider);
            } else {
                settingsComposite = new Composite((Composite)this.fSettingsGroup, 0);
                this.fSelectedProvider.getProvider().init(this.fExportDialogPageAdapter, settingsComposite, this.fFigure);
                this.fSettingComposites.put(this.fSelectedProvider, settingsComposite);
            }
            this.fSettingsGroup.setVisible(settingsComposite.getChildren().length > 0);
            settingsComposite.setParent((Composite)this.fSettingsGroup);
            settingsComposite.setVisible(true);
            this.fSettingsGroup.layout(true, true);
        }
    }

    String getFileName() {
        return this.fFileTextField.getText();
    }

    ImageExportProviderManager.ImageExportProviderInfo getSelectedProvider() {
        return this.fSelectedProvider;
    }

    private File chooseFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.ExportAsImagePage_7);
        File file = new File(this.fFileTextField.getText());
        dialog.setFileName(file.getName());
        Object extensions = "*.";
        Iterator<String> iter = this.fSelectedProvider.getExtensions().iterator();
        extensions = (String)extensions + iter.next();
        while (iter.hasNext()) {
            extensions = (String)extensions + ";*." + iter.next();
        }
        dialog.setFilterExtensions(new String[]{extensions, "*.*"});
        dialog.setOverwrite(false);
        String path = dialog.open();
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    private void validateFields() {
        String fileName = this.getFileName();
        if (!StringUtils.isSetAfterTrim(fileName)) {
            this.setErrorMessage(Messages.ExportAsImagePage_8);
            return;
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    void storePreferences() {
        File parentFile = new File(this.getFileName()).getAbsoluteFile().getParentFile();
        if (parentFile != null) {
            ArchiPlugin.getInstance().getPreferenceStore().setValue(PREFS_LAST_FOLDER, parentFile.getAbsolutePath());
        }
        if (this.fSelectedProvider != null) {
            ArchiPlugin.getInstance().getPreferenceStore().setValue(PREFS_LAST_PROVIDER, this.fSelectedProvider.getID());
        }
    }

    private ImageExportProviderManager.ImageExportProviderInfo getImageProviderInfoFromID(String id) {
        if (id == null) {
            return null;
        }
        for (ImageExportProviderManager.ImageExportProviderInfo provider : this.fImageProviders) {
            if (!id.equals(provider.getID())) continue;
            return provider;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.fTempShell != null) {
            this.fTempShell.dispose();
        }
    }
}

