/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.wizard;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.diagram.ImageExportProviderManager;
import com.archimatetool.editor.diagram.wizard.ExportAsImagePage;
import com.archimatetool.editor.diagram.wizard.Messages;
import java.io.File;
import java.io.IOException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExportAsImageWizard
extends Wizard {
    private IFigure fFigure;
    private String fName;
    private ExportAsImagePage fPage;

    public ExportAsImageWizard(IFigure figure, String name) {
        this.fFigure = figure;
        this.fName = name;
        this.setWindowTitle(Messages.ExportAsImageWizard_0);
    }

    public void addPages() {
        this.fPage = new ExportAsImagePage(this.fFigure, this.fName);
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        boolean result;
        final ImageExportProviderManager.ImageExportProviderInfo provider = this.fPage.getSelectedProvider();
        if (provider == null) {
            return false;
        }
        final File file = new File(this.fPage.getFileName());
        try {
            file.getCanonicalPath();
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportAsImageWizard_1, (String)Messages.ExportAsImageWizard_2);
            return false;
        }
        if (file.exists() && !(result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ExportAsImageWizard_3, (String)NLS.bind((String)Messages.ExportAsImageWizard_4, (Object)file.getAbsolutePath())))) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    provider.getProvider().export(provider.getID(), file);
                    ExportAsImageWizard.this.fPage.storePreferences();
                }
                catch (Throwable ex) {
                    Logger.log(4, "Error exporting image", ex);
                    MessageDialog.openError((Shell)ExportAsImageWizard.this.getShell(), (String)Messages.ExportAsImageWizard_5, (String)(Messages.ExportAsImageWizard_6 + " " + (ex.getMessage() == null ? ex.toString() : ex.getMessage())));
                }
            }
        });
        return true;
    }
}

