/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model;

import com.archimatetool.editor.preferences.ConnectionPreferences;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelBendpoint;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class DiagramModelUtils {
    public static List<IDiagramModel> findReferencedDiagramsForArchimateConcept(IArchimateConcept archimateConcept) {
        ArrayList<IDiagramModel> models = new ArrayList<IDiagramModel>();
        if (archimateConcept != null && archimateConcept.getArchimateModel() != null) {
            for (IDiagramModelArchimateComponent dmc : archimateConcept.getReferencingDiagramComponents()) {
                if (models.contains(dmc.getDiagramModel())) continue;
                models.add(dmc.getDiagramModel());
            }
        }
        return models;
    }

    public static boolean isArchimateConceptReferencedInDiagrams(IArchimateConcept archimateConcept) {
        if (archimateConcept == null || archimateConcept.getArchimateModel() == null) {
            return false;
        }
        return !archimateConcept.getReferencingDiagramComponents().isEmpty();
    }

    public static List<IDiagramModelArchimateComponent> findDiagramModelComponentsForArchimateConcept(IDiagramModel diagramModel, IArchimateConcept archimateConcept) {
        ArrayList<IDiagramModelArchimateComponent> list = new ArrayList<IDiagramModelArchimateComponent>();
        if (archimateConcept instanceof IArchimateElement) {
            list.addAll(DiagramModelUtils.findDiagramModelObjectsForElement(diagramModel, (IArchimateElement)archimateConcept));
        } else if (archimateConcept instanceof IArchimateRelationship) {
            list.addAll(DiagramModelUtils.findDiagramModelConnectionsForRelation(diagramModel, (IArchimateRelationship)archimateConcept));
        }
        return list;
    }

    public static List<IDiagramModelArchimateObject> findDiagramModelObjectsForElement(IDiagramModel diagramModel, IArchimateElement element) {
        return DiagramModelUtils.findDiagramModelObjectsForElementByIterator(diagramModel, element);
    }

    public static List<IDiagramModelArchimateConnection> findDiagramModelConnectionsForRelation(IDiagramModel diagramModel, IArchimateRelationship relationship) {
        return DiagramModelUtils.findDiagramModelConnectionsForRelationByIterator(diagramModel, relationship);
    }

    private static List<IDiagramModelArchimateObject> findDiagramModelObjectsForElementByIterator(IDiagramModel diagramModel, IArchimateElement element) {
        HashSet<IDiagramModelArchimateObject> set = new HashSet<IDiagramModelArchimateObject>();
        TreeIterator iter = diagramModel.eAllContents();
        while (iter.hasNext()) {
            IDiagramModelArchimateObject dmo;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IDiagramModelArchimateObject) || (dmo = (IDiagramModelArchimateObject)eObject).getArchimateElement() != element) continue;
            set.add(dmo);
        }
        return new ArrayList<IDiagramModelArchimateObject>(set);
    }

    private static List<IDiagramModelArchimateConnection> findDiagramModelConnectionsForRelationByIterator(IDiagramModel diagramModel, IArchimateRelationship relationship) {
        HashSet<IDiagramModelArchimateConnection> set = new HashSet<IDiagramModelArchimateConnection>();
        TreeIterator iter = diagramModel.eAllContents();
        while (iter.hasNext()) {
            IDiagramModelArchimateConnection connection;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IDiagramModelArchimateConnection) || (connection = (IDiagramModelArchimateConnection)eObject).getArchimateRelationship() != relationship) continue;
            set.add(connection);
        }
        return new ArrayList<IDiagramModelArchimateConnection>(set);
    }

    private static List<IDiagramModelArchimateObject> findDiagramModelObjectsForElementByReference(IDiagramModel diagramModel, IArchimateElement element) {
        HashSet<IDiagramModelArchimateObject> set = new HashSet<IDiagramModelArchimateObject>();
        for (IDiagramModelArchimateObject dmo : element.getReferencingDiagramObjects()) {
            if (dmo.getDiagramModel() != diagramModel) continue;
            set.add(dmo);
        }
        return new ArrayList<IDiagramModelArchimateObject>(set);
    }

    private static List<IDiagramModelArchimateConnection> findDiagramModelConnectionsForRelationByReference(IDiagramModel diagramModel, IArchimateRelationship relationship) {
        HashSet<IDiagramModelArchimateConnection> set = new HashSet<IDiagramModelArchimateConnection>();
        for (IDiagramModelArchimateConnection dmc : relationship.getReferencingDiagramConnections()) {
            if (dmc.getDiagramModel() != diagramModel) continue;
            set.add(dmc);
        }
        return new ArrayList<IDiagramModelArchimateConnection>(set);
    }

    public static List<IDiagramModelReference> findDiagramModelReferences(IDiagramModelContainer container, IDiagramModel diagramModel) {
        ArrayList<IDiagramModelReference> list = new ArrayList<IDiagramModelReference>();
        for (IDiagramModelObject object : container.getChildren()) {
            if (object instanceof IDiagramModelReference && ((IDiagramModelReference)object).getReferencedModel() == diagramModel) {
                list.add((IDiagramModelReference)object);
            }
            if (!(object instanceof IDiagramModelContainer)) continue;
            list.addAll(DiagramModelUtils.findDiagramModelReferences((IDiagramModelContainer)object, diagramModel));
        }
        return list;
    }

    public static boolean hasDiagramModelReference(IDiagramModel diagramModel) {
        if (diagramModel.getArchimateModel() != null) {
            TreeIterator iter = diagramModel.getArchimateModel().getFolder(FolderType.DIAGRAMS).eAllContents();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof IDiagramModelReference) || ((IDiagramModelReference)eObject).getReferencedModel() != diagramModel) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDiagramModelArchimateConnection(IConnectable srcObject, IConnectable tgtObject, IArchimateRelationship relation) {
        for (IDiagramModelConnection conn : srcObject.getSourceConnections()) {
            IArchimateRelationship r;
            if (!(conn instanceof IDiagramModelArchimateConnection) || (r = ((IDiagramModelArchimateConnection)conn).getArchimateRelationship()) != relation || conn.getSource() != srcObject || conn.getTarget() != tgtObject) continue;
            return true;
        }
        return false;
    }

    public static boolean isNestedConnectionTypeRelationship(IArchimateRelationship relation) {
        for (EClass eClass : ConnectionPreferences.getRelationsClassesForHiding()) {
            if (relation.eClass() != eClass) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldBeHiddenConnection(IDiagramModelConnection connection) {
        IConnectable iConnectable;
        IConnectable iConnectable2;
        if (!ConnectionPreferences.useNestedConnections()) {
            return false;
        }
        if (connection instanceof IDiagramModelArchimateConnection) {
            IDiagramModelArchimateConnection dmc = (IDiagramModelArchimateConnection)connection;
            IConnectable iConnectable3 = connection.getSource();
            if (iConnectable3 instanceof IDiagramModelArchimateObject) {
                IDiagramModelArchimateObject target;
                IDiagramModelArchimateObject source = (IDiagramModelArchimateObject)iConnectable3;
                IConnectable iConnectable4 = connection.getTarget();
                if (iConnectable4 instanceof IDiagramModelArchimateObject && (source == (target = (IDiagramModelArchimateObject)iConnectable4).eContainer() || target == source.eContainer())) {
                    return DiagramModelUtils.isNestedConnectionTypeRelationship(dmc.getArchimateRelationship());
                }
            }
        }
        if ((iConnectable2 = connection.getSource()) instanceof IDiagramModelObject) {
            IDiagramModelObject target;
            IDiagramModelObject source = (IDiagramModelObject)iConnectable2;
            IConnectable iConnectable5 = connection.getTarget();
            if (iConnectable5 instanceof IDiagramModelObject && (source == (target = (IDiagramModelObject)iConnectable5).eContainer() || target == source.eContainer())) {
                return true;
            }
        }
        if ((iConnectable = connection.getSource()) instanceof IDiagramModelConnection) {
            IDiagramModelConnection dmc = (IDiagramModelConnection)iConnectable;
            return DiagramModelUtils.shouldBeHiddenConnection(dmc);
        }
        IConnectable iConnectable6 = connection.getTarget();
        if (iConnectable6 instanceof IDiagramModelConnection) {
            IDiagramModelConnection dmc = (IDiagramModelConnection)iConnectable6;
            return DiagramModelUtils.shouldBeHiddenConnection(dmc);
        }
        return false;
    }

    public static IDiagramModelContainer getAncestorContainer(IDiagramModelObject object) {
        EObject container = object.eContainer();
        while (container != null && !(container instanceof IDiagramModel) && !(container.eContainer() instanceof IDiagramModel)) {
            container = container.eContainer();
        }
        return (IDiagramModelContainer)container;
    }

    public static boolean hasExistingConnectionType(IDiagramModelObject source, IDiagramModelObject target, EClass relationshipType) {
        for (IDiagramModelConnection connection : source.getSourceConnections()) {
            if (!(connection instanceof IDiagramModelArchimateConnection) || !connection.getTarget().equals(target)) continue;
            EClass type = ((IDiagramModelArchimateConnection)connection).getArchimateRelationship().eClass();
            return type.equals(relationshipType);
        }
        return false;
    }

    public static boolean hasCycle(IConnectable source, IConnectable target) {
        for (IDiagramModelConnection connection : source.getTargetConnections()) {
            if (connection.getSource().equals(target)) {
                return true;
            }
            if (!DiagramModelUtils.hasCycle(connection.getSource(), target)) continue;
            return true;
        }
        return false;
    }

    public static final IBounds getAbsoluteBounds(IDiagramModelComponent dmc) {
        if (dmc instanceof IDiagramModelObject) {
            return DiagramModelUtils.getAbsoluteBounds((IDiagramModelObject)dmc);
        }
        boolean cfr_ignored_0 = dmc instanceof IDiagramModelConnection;
        return null;
    }

    public static final IBounds getAbsoluteBounds(IDiagramModelObject dmo) {
        IBounds bounds = dmo.getBounds().getCopy();
        EObject container = dmo.eContainer();
        while (container instanceof IDiagramModelObject) {
            IDiagramModelObject parent = (IDiagramModelObject)container;
            IBounds parentBounds = parent.getBounds().getCopy();
            bounds.setX(bounds.getX() + parentBounds.getX());
            bounds.setY(bounds.getY() + parentBounds.getY());
            container = container.eContainer();
        }
        return bounds;
    }

    public static final IBounds getRelativeBounds(IBounds absoluteBounds, IDiagramModelObject parent) {
        IBounds bounds = absoluteBounds.getCopy();
        do {
            IBounds parentBounds = parent.getBounds();
            bounds.setX(bounds.getX() - parentBounds.getX());
            bounds.setY(bounds.getY() - parentBounds.getY());
        } while ((parent = parent.eContainer() instanceof IDiagramModelObject ? (IDiagramModelObject)parent.eContainer() : null) != null);
        return bounds;
    }

    public static List<Point> getAbsoluteBendpointPositions(IDiagramModelConnection connection) {
        ArrayList<Point> points = new ArrayList<Point>();
        if (!(connection.getSource() instanceof IDiagramModelObject) || !(connection.getTarget() instanceof IDiagramModelObject)) {
            return points;
        }
        double bpindex = 1.0;
        double bpcount = connection.getBendpoints().size() + 1;
        for (IDiagramModelBendpoint bendpoint : connection.getBendpoints()) {
            double bpweight = bpindex / bpcount;
            IBounds srcBounds = DiagramModelUtils.getAbsoluteBounds((IDiagramModelComponent)connection.getSource());
            double startX = srcBounds.getX() + srcBounds.getWidth() / 2 + bendpoint.getStartX();
            double startY = srcBounds.getY() + srcBounds.getHeight() / 2 + bendpoint.getStartY();
            IBounds tgtBounds = DiagramModelUtils.getAbsoluteBounds((IDiagramModelComponent)connection.getTarget());
            double endX = tgtBounds.getX() + tgtBounds.getWidth() / 2 + bendpoint.getEndX();
            double endY = tgtBounds.getY() + tgtBounds.getHeight() / 2 + bendpoint.getEndY();
            int x = (int)((startX *= 1.0 - bpweight) + (endX *= bpweight));
            int y = (int)((startY *= 1.0 - bpweight) + (endY *= bpweight));
            points.add(new Point(x, y));
            bpindex += 1.0;
        }
        return points;
    }

    public static IDiagramModelBendpoint createBendPointFromAbsolutePosition(IDiagramModelConnection connection, int x, int y) {
        if (!(connection.getSource() instanceof IDiagramModelObject) || !(connection.getTarget() instanceof IDiagramModelObject)) {
            return null;
        }
        IDiagramModelBendpoint bendpoint = IArchimateFactory.eINSTANCE.createDiagramModelBendpoint();
        IBounds srcBounds = DiagramModelUtils.getAbsoluteBounds((IDiagramModelComponent)connection.getSource());
        IBounds tgtBounds = DiagramModelUtils.getAbsoluteBounds((IDiagramModelComponent)connection.getTarget());
        int startX = x - (srcBounds.getX() + srcBounds.getWidth() / 2);
        int startY = y - (srcBounds.getY() + srcBounds.getHeight() / 2);
        bendpoint.setStartX(startX);
        bendpoint.setStartY(startY);
        int endX = x - (tgtBounds.getX() + tgtBounds.getWidth() / 2);
        int endY = y - (tgtBounds.getY() + tgtBounds.getHeight() / 2);
        bendpoint.setEndX(endX);
        bendpoint.setEndY(endY);
        return bendpoint;
    }

    public static boolean outerBoundsContainsInnerBounds(IBounds outer, IBounds inner) {
        return outer.getX() <= inner.getX() && inner.getX() + inner.getWidth() <= outer.getX() + outer.getWidth() && outer.getY() <= inner.getY() && inner.getY() + inner.getHeight() <= outer.getY() + outer.getHeight();
    }
}

