/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.model.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.dialog.ErrorMessageDialog;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IIdentifier;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProfiles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ModelChecker {
    private static boolean NO_MODELCHECK = Arrays.asList(Platform.getApplicationArgs()).contains("-noModelCheck");
    protected IArchimateModel model;
    protected List<String> errorMessages;

    public ModelChecker(IArchimateModel model) {
        this.model = model;
    }

    public boolean checkAll() {
        this.errorMessages = new ArrayList<String>();
        if (NO_MODELCHECK) {
            return true;
        }
        HashMap<IArchimateConcept, Integer> dmcMap = new HashMap<IArchimateConcept, Integer>();
        this.errorMessages.addAll(this.checkHasIdentifier((IIdentifier)this.model));
        TreeIterator iter = this.model.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof IIdentifier) {
                IIdentifier identifier = (IIdentifier)eObject;
                this.errorMessages.addAll(this.checkHasIdentifier(identifier));
            }
            if (eObject instanceof IArchimateRelationship) {
                IArchimateRelationship relationship = (IArchimateRelationship)eObject;
                this.errorMessages.addAll(this.checkRelationship(relationship));
            }
            if (eObject instanceof IDiagramModelArchimateObject) {
                IDiagramModelArchimateObject dmo = (IDiagramModelArchimateObject)eObject;
                this.errorMessages.addAll(this.checkDiagramModelArchimateObject(dmo));
                this.incrementInstanceCount((IDiagramModelArchimateComponent)dmo, dmcMap);
            }
            if (eObject instanceof IDiagramModelArchimateConnection) {
                IDiagramModelArchimateConnection dmc = (IDiagramModelArchimateConnection)eObject;
                this.errorMessages.addAll(this.checkDiagramModelArchimateConnection(dmc));
                this.incrementInstanceCount((IDiagramModelArchimateComponent)dmc, dmcMap);
            }
            if (eObject instanceof IArchimateConcept || eObject instanceof IDiagramModel) {
                this.errorMessages.addAll(this.checkObjectInCorrectFolder((IArchimateModelObject)eObject));
            }
            if (eObject instanceof IFolder) {
                IFolder folder = (IFolder)eObject;
                this.errorMessages.addAll(this.checkFolderContainsCorrectObjects(folder));
            }
            if (eObject instanceof IProfiles) {
                IProfiles profiles = (IProfiles)eObject;
                this.errorMessages.addAll(this.checkProfiles(profiles));
            }
            this.errorMessages.addAll(this.checkObject(eObject));
        }
        this.errorMessages.addAll(this.checkDiagramComponentInstanceCount(dmcMap));
        return this.errorMessages.isEmpty();
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void showErrorDialog(Shell shell) {
        String summary = this.createMessageSummary();
        if (summary != null) {
            this.logErrorMesssages();
            ErrorMessageDialog.open(shell, Messages.ModelChecker_1, Messages.ModelChecker_0 + " " + this.model.getName(), summary);
        }
    }

    public String createMessageSummary() {
        if (this.errorMessages == null || this.errorMessages.isEmpty()) {
            return null;
        }
        this.errorMessages.sort(null);
        StringBuilder sb = new StringBuilder();
        for (String message : this.errorMessages) {
            sb.append(message);
            sb.append('\n');
        }
        return sb.toString();
    }

    public void logErrorMesssages() {
        if (this.errorMessages == null || this.errorMessages.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Model Error: ");
        sb.append(this.model.getName());
        if (this.model.getFile() != null) {
            sb.append(" [");
            sb.append(this.model.getFile().getAbsolutePath());
            sb.append("]");
        }
        sb.append(':');
        sb.append('\n');
        for (String message : this.errorMessages) {
            sb.append("   ");
            sb.append(message);
            sb.append('\n');
        }
        Logger.logError(sb.toString());
    }

    protected List<String> checkFolderStructure() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.model.getFolder(FolderType.STRATEGY) == null) {
            messages.add(Messages.ModelChecker_23);
        }
        if (this.model.getFolder(FolderType.BUSINESS) == null) {
            messages.add(Messages.ModelChecker_2);
        }
        if (this.model.getFolder(FolderType.APPLICATION) == null) {
            messages.add(Messages.ModelChecker_3);
        }
        if (this.model.getFolder(FolderType.TECHNOLOGY) == null) {
            messages.add(Messages.ModelChecker_4);
        }
        if (this.model.getFolder(FolderType.OTHER) == null) {
            messages.add(Messages.ModelChecker_5);
        }
        if (this.model.getFolder(FolderType.IMPLEMENTATION_MIGRATION) == null) {
            messages.add(Messages.ModelChecker_6);
        }
        if (this.model.getFolder(FolderType.MOTIVATION) == null) {
            messages.add(Messages.ModelChecker_7);
        }
        if (this.model.getFolder(FolderType.RELATIONS) == null) {
            messages.add(Messages.ModelChecker_8);
        }
        if (this.model.getFolder(FolderType.DIAGRAMS) == null) {
            messages.add(Messages.ModelChecker_9);
        }
        return messages;
    }

    protected List<String> checkHasIdentifier(IIdentifier eObject) {
        return StringUtils.isSet(eObject.getId()) ? List.of() : List.of(NLS.bind((String)Messages.ModelChecker_10, (Object)ArchiLabelProvider.INSTANCE.getLabel(eObject)));
    }

    protected List<String> checkRelationship(IArchimateRelationship relation) {
        ArrayList<String> messages = new ArrayList<String>();
        String name = "(" + relation.getId() + ")";
        if (relation.getSource() == null) {
            messages.add(NLS.bind((String)Messages.ModelChecker_19, (Object)name));
        } else if (relation.getSource().getArchimateModel() == null) {
            messages.add(NLS.bind((String)Messages.ModelChecker_20, (Object)name));
        }
        if (relation.getTarget() == null) {
            messages.add(NLS.bind((String)Messages.ModelChecker_21, (Object)name));
        } else if (relation.getTarget().getArchimateModel() == null) {
            messages.add(NLS.bind((String)Messages.ModelChecker_22, (Object)name));
        }
        return messages;
    }

    protected List<String> checkDiagramModelArchimateObject(IDiagramModelArchimateObject dmo) {
        String name = dmo.getDiagramModel() == null ? Messages.ModelChecker_11 : "'" + dmo.getDiagramModel().getName() + "' (" + dmo.getId() + ")";
        IArchimateElement element = dmo.getArchimateElement();
        if (element == null) {
            return List.of(NLS.bind((String)Messages.ModelChecker_12, (Object)name));
        }
        if (element.getArchimateModel() == null) {
            return List.of(NLS.bind((String)Messages.ModelChecker_13, (Object)name));
        }
        return List.of();
    }

    protected List<String> checkDiagramModelArchimateConnection(IDiagramModelArchimateConnection connection) {
        ArrayList<String> messages = new ArrayList<String>();
        String name = connection.getDiagramModel() == null ? Messages.ModelChecker_11 : "'" + connection.getDiagramModel().getName() + "' (" + connection.getId() + ")";
        IArchimateRelationship relation = connection.getArchimateRelationship();
        if (relation == null) {
            messages.add(NLS.bind((String)Messages.ModelChecker_15, (Object)name));
        } else {
            if (relation.getArchimateModel() == null) {
                messages.add(NLS.bind((String)Messages.ModelChecker_16, (Object)name));
            }
            if (relation.getSource() != null && relation.getSource().getArchimateModel() == null) {
                messages.add(NLS.bind((String)Messages.ModelChecker_17, (Object)name));
            }
            if (relation.getTarget() != null && relation.getTarget().getArchimateModel() == null) {
                messages.add(NLS.bind((String)Messages.ModelChecker_18, (Object)name));
            }
            if (((IDiagramModelArchimateComponent)connection.getSource()).getArchimateConcept() != relation.getSource()) {
                messages.add(NLS.bind((String)Messages.ModelChecker_14, (Object)name));
            }
            if (((IDiagramModelArchimateComponent)connection.getTarget()).getArchimateConcept() != relation.getTarget()) {
                messages.add(NLS.bind((String)Messages.ModelChecker_27, (Object)name));
            }
        }
        return messages;
    }

    /*
     * WARNING - void declaration
     */
    protected List<String> checkObjectInCorrectFolder(IArchimateModelObject object) {
        void folder;
        EObject eObject = object.eContainer();
        if (!(eObject instanceof IFolder)) {
            return List.of();
        }
        IFolder iFolder = (IFolder)eObject;
        IFolder topFolder = folder.getArchimateModel().getDefaultFolderForObject((EObject)object);
        if (folder == topFolder) {
            return List.of();
        }
        EObject e = folder;
        while ((e = e.eContainer()) != null) {
            if (e != topFolder) continue;
            return List.of();
        }
        return List.of(NLS.bind((String)Messages.ModelChecker_26, (Object[])new String[]{object.getName(), object.getId(), folder.getName()}));
    }

    protected List<String> checkFolderContainsCorrectObjects(IFolder folder) {
        ArrayList<String> messages = new ArrayList<String>();
        for (EObject eObject : folder.getElements()) {
            if (eObject instanceof IArchimateConcept || eObject instanceof IDiagramModel) continue;
            String name = "(Folder: " + folder.getId() + " Object: " + ((IIdentifier)eObject).getId() + ")";
            messages.add(NLS.bind((String)Messages.ModelChecker_25, (Object)name));
        }
        return messages;
    }

    protected List<String> checkProfiles(IProfiles profilesObject) {
        ArrayList<String> messages = new ArrayList<String>();
        for (IProfile profile : profilesObject.getProfiles()) {
            EClass eClass;
            if (profile.getArchimateModel() != ((IArchimateModelObject)profilesObject).getArchimateModel()) {
                messages.add(NLS.bind((String)Messages.ModelChecker_28, (Object)profile.getId()));
            }
            if ((eClass = profile.getConceptClass()) != null && eClass == profilesObject.eClass()) continue;
            messages.add(NLS.bind((String)Messages.ModelChecker_29, (Object)profile.getId()));
        }
        return messages;
    }

    protected List<String> checkObject(EObject eObject) {
        return List.of();
    }

    private void incrementInstanceCount(IDiagramModelArchimateComponent dmc, Map<IArchimateConcept, Integer> map) {
        IArchimateConcept concept = dmc.getArchimateConcept();
        if (concept != null) {
            int n;
            Integer count = map.get(concept);
            if (count == null) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            map.put(concept, n);
        }
    }

    private List<String> checkDiagramComponentInstanceCount(Map<IArchimateConcept, Integer> map) {
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<IArchimateConcept, Integer> entry : map.entrySet()) {
            IArchimateConcept concept = entry.getKey();
            int count = entry.getValue();
            if (concept.getReferencingDiagramComponents().size() == count) continue;
            String name = "(" + concept.getId() + ")";
            messages.add(NLS.bind((String)Messages.ModelChecker_24, (Object)name));
        }
        return messages;
    }
}

